/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeProperty;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import java.lang.reflect.Array;

public class ExprDotForgePropertyArray
implements ExprDotEval,
ExprDotForge {
    private final EventPropertyGetterSPI getter;
    private final EPType returnType;
    private final ExprNode indexExpression;
    private final Class arrayType;
    private final String propertyName;

    public ExprDotForgePropertyArray(EventPropertyGetterSPI getter, EPType returnType, ExprNode indexExpression, Class arrayType, String propertyName) {
        this.getter = getter;
        this.returnType = returnType;
        this.indexExpression = indexExpression;
        this.arrayType = arrayType;
        this.propertyName = propertyName;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (!(target instanceof EventBean)) {
            return null;
        }
        Object array = this.getter.get((EventBean)target);
        if (array == null) {
            return null;
        }
        Integer index = (Integer)this.indexExpression.getForge().getExprEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (index == null) {
            return null;
        }
        return Array.get(array, index);
    }

    @Override
    public EPType getTypeInfo() {
        return this.returnType;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitPropertySource();
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        return this;
    }

    @Override
    public ExprDotForge getDotForge() {
        return this;
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, Class innerType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        Class type = EPTypeHelper.getCodegenReturnType(this.returnType);
        CodegenMethod method = parent.makeChild(type, ExprDotForgeProperty.class, (CodegenScope)classScope).addParam(innerType, "target").addParam(Integer.class, "index");
        method.getBlock().ifNotInstanceOf("target", EventBean.class).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(this.arrayType, "array", CodegenLegoCast.castSafeFromObjectType(this.arrayType, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("target")), method, classScope))).ifRefNullReturnNull("index").ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("index"), CodegenExpressionRelational.CodegenRelational.GE, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")))).blockThrow(CodegenExpressionBuilder.newInstance(EPException.class, CodegenExpressionBuilder.concat(CodegenExpressionBuilder.constant("Array length "), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionBuilder.constant(" less than index "), CodegenExpressionBuilder.ref("index"), CodegenExpressionBuilder.constant(" for property '" + this.propertyName + "'")))).methodReturn(CodegenLegoCast.castSafeFromObjectType(type, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.cast(Integer.TYPE, (CodegenExpression)CodegenExpressionBuilder.ref("index")))));
        return CodegenExpressionBuilder.localMethod(method, inner, this.indexExpression.getForge().evaluateCodegen(Integer.class, method, symbols, classScope));
    }
}

