/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExprDotStaticMethodWrapArrayEvents
implements ExprDotStaticMethodWrap {
    private EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private BeanEventType type;

    public ExprDotStaticMethodWrapArrayEvents(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventType type) {
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.type = type;
    }

    @Override
    public EPType getTypeInfo() {
        return EPTypeHelper.collectionOfEvents(this.type);
    }

    @Override
    public Collection convertNonNull(Object result) {
        if (!result.getClass().isArray()) {
            return null;
        }
        return new WrappingCollection(this.eventBeanTypedEventFactory, this.type, result);
    }

    @Override
    public CodegenExpression codegenConvertNonNull(CodegenExpression result, CodegenMethodScope codegenMethodScope, CodegenClassScope classScope) {
        CodegenExpressionField eventSvcMember = classScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField typeMember = classScope.addFieldUnshared(true, BeanEventType.class, CodegenExpressionBuilder.cast(BeanEventType.class, EventTypeUtility.resolveTypeCodegen(this.type, EPStatementInitServices.REF)));
        return CodegenExpressionBuilder.newInstance(WrappingCollection.class, eventSvcMember, typeMember, result);
    }

    public static class WrappingIterator
    implements Iterator<EventBean> {
        private EventBeanTypedEventFactory eventBeanTypedEventFactory;
        private BeanEventType type;
        private Object array;
        private int count;

        public WrappingIterator(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventType type, Object array) {
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
            this.type = type;
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return Array.getLength(this.array) > this.count;
        }

        @Override
        public EventBean next() {
            Object next;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if ((next = Array.get(this.array, this.count++)) == null) {
                return null;
            }
            return this.eventBeanTypedEventFactory.adapterForTypedBean(next, this.type);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WrappingCollection
    implements Collection<EventBean> {
        private EventBeanTypedEventFactory eventBeanTypedEventFactory;
        private BeanEventType type;
        private Object array;

        public WrappingCollection(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventType type, Object array) {
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
            this.type = type;
            this.array = array;
        }

        @Override
        public int size() {
            return Array.getLength(this.array);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<EventBean> iterator() {
            return new WrappingIterator(this.eventBeanTypedEventFactory, this.type, this.array);
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public boolean add(EventBean eventBean) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean addAll(Collection<? extends EventBean> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Read-only implementation");
        }
    }
}

