/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEvent;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDotScalarIterable
implements ExprEnumerationForge,
ExprEnumerationEval,
ExprEnumerationGivenEvent,
ExprEnumerationGivenEventForge,
ExprNodeRenderable {
    private static final Logger log = LoggerFactory.getLogger(PropertyDotScalarIterable.class);
    private final String propertyName;
    private final int streamId;
    private final EventPropertyGetterSPI getter;
    private final Class componentType;
    private final Class getterReturnType;

    public PropertyDotScalarIterable(String propertyName, int streamId, EventPropertyGetterSPI getter, Class componentType, Class getterReturnType) {
        this.propertyName = propertyName;
        this.streamId = streamId;
        this.getter = getter;
        this.componentType = componentType;
        this.getterReturnType = getterReturnType;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.evaluateInternal(eventsPerStream[this.streamId]);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(codegenMethodScope);
        return this.codegenEvaluateInternal(CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamId)), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateEventGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprEnumerationGivenEventSymbol symbols, CodegenClassScope codegenClassScope) {
        if (JavaClassHelper.isImplementsInterface(this.getterReturnType, Collection.class)) {
            return this.getter.eventBeanGetCodegen(symbols.getAddEvent(codegenMethodScope), codegenMethodScope, codegenClassScope);
        }
        CodegenMethod method = codegenMethodScope.makeChild(Collection.class, PropertyDotScalarIterable.class, (CodegenScope)codegenClassScope);
        method.getBlock().declareVar(this.getterReturnType, "result", CodegenLegoCast.castSafeFromObjectType(Iterable.class, this.getter.eventBeanGetCodegen(symbols.getAddEvent(method), codegenMethodScope, codegenClassScope))).ifRefNullReturnNull("result").methodReturn(CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "iterableToCollection", CodegenExpressionBuilder.ref("result")));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public Collection evaluateEventGetROCollectionScalar(EventBean event, ExprEvaluatorContext context) {
        return this.evaluateInternal(event);
    }

    private Collection evaluateInternal(EventBean event) {
        Object result = this.getter.get(event);
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (!(result instanceof Iterable)) {
            log.warn("Expected iterable-type input from property '" + this.propertyName + "' but received " + result.getClass());
            return null;
        }
        return CollectionUtil.iterableToCollection((Iterable)result);
    }

    private CodegenExpression codegenEvaluateInternal(CodegenExpression event, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (JavaClassHelper.isImplementsInterface(this.getterReturnType, Collection.class)) {
            return this.getter.eventBeanGetCodegen(event, codegenMethodScope, codegenClassScope);
        }
        CodegenMethod method = codegenMethodScope.makeChild(Collection.class, PropertyDotScalarIterable.class, (CodegenScope)codegenClassScope).addParam(EventBean.class, "event").getBlock().declareVar(this.getterReturnType, "result", CodegenLegoCast.castSafeFromObjectType(Iterable.class, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("event"), codegenMethodScope, codegenClassScope))).ifRefNullReturnNull("result").methodReturn(CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "iterableToCollection", CodegenExpressionBuilder.ref("result")));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(event).call();
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.componentType;
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public Collection<EventBean> evaluateEventGetROCollectionEvents(EventBean event, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public EventBean evaluateEventGetEventBean(EventBean event, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public CodegenExpression evaluateEventGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprEnumerationGivenEventSymbol symbols, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public CodegenExpression evaluateEventGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprEnumerationGivenEventSymbol symbols, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence, ExprNodeRenderableFlags flags) {
        writer.append(this.getClass().getSimpleName());
    }
}

