/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.arrayOf;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormEventPlus;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;

public class EnumArrayOfEventPlus
extends ThreeFormEventPlus {
    private final Class arrayComponentType;

    public EnumArrayOfEventPlus(ExprDotEvalParamLambda lambda, ObjectArrayEventType indexEventType, int numParameters, Class arrayComponentType) {
        super(lambda, indexEventType, numParameters);
        this.arrayComponentType = arrayComponentType;
    }

    @Override
    public EnumEval getEnumEvaluator() {
        final ExprEvaluator inner = this.innerExpression.getExprEvaluator();
        return new EnumEval(){

            @Override
            public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection enumcoll, boolean isNewData, ExprEvaluatorContext context) {
                Object array = Array.newInstance(EnumArrayOfEventPlus.this.arrayComponentType, enumcoll.size());
                if (enumcoll.isEmpty()) {
                    return array;
                }
                ObjectArrayEventBean indexEvent = new ObjectArrayEventBean(new Object[2], EnumArrayOfEventPlus.this.fieldEventType);
                Object[] props = indexEvent.getProperties();
                props[1] = enumcoll.size();
                eventsLambda[EnumArrayOfEventPlus.this.getStreamNumLambda() + 1] = indexEvent;
                Collection beans = enumcoll;
                int count = -1;
                for (EventBean next : beans) {
                    props[0] = ++count;
                    eventsLambda[EnumArrayOfEventPlus.this.getStreamNumLambda()] = next;
                    Object item = inner.evaluate(eventsLambda, isNewData, context);
                    Array.set(array, count, item);
                }
                return array;
            }
        };
    }

    @Override
    public Class returnType() {
        return JavaClassHelper.getArrayType(this.arrayComponentType);
    }

    @Override
    public CodegenExpression returnIfEmptyOptional() {
        return CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.constant(0));
    }

    @Override
    public void initBlock(CodegenBlock block, CodegenMethod methodNode, ExprForgeCodegenSymbol scope, CodegenClassScope codegenClassScope) {
        Class arrayType = JavaClassHelper.getArrayType(this.arrayComponentType);
        block.declareVar(arrayType, "result", CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.exprDotMethod(EnumForgeCodegenNames.REF_ENUMCOLL, "size", new CodegenExpression[0])));
    }

    @Override
    public void forEachBlock(CodegenBlock block, CodegenMethod methodNode, ExprForgeCodegenSymbol scope, CodegenClassScope codegenClassScope) {
        block.declareVar(Object.class, "item", this.innerExpression.evaluateCodegen(Object.class, methodNode, scope, codegenClassScope)).assignArrayElement(CodegenExpressionBuilder.ref("result"), (CodegenExpression)CodegenExpressionBuilder.ref("count"), CodegenExpressionBuilder.cast(this.arrayComponentType, (CodegenExpression)CodegenExpressionBuilder.ref("item")));
    }

    @Override
    public void returnResult(CodegenBlock block) {
        block.methodReturn(CodegenExpressionBuilder.ref("result"));
    }
}

