/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ExprDotForgeLambdaThreeForm;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormEventPlainFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormEventPlusFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormNoParamFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormScalarFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumEvent;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumEventPlus;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumScalar;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumScalarNoParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.ExprDotEvalSumMethod;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.ExprDotEvalSumMethodFactory;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;

public class ExprDotForgeSumOf
extends ExprDotForgeLambdaThreeForm {
    private ExprDotEvalSumMethodFactory aggMethodFactory;

    @Override
    protected EPType initAndNoParamsReturnType(EventType inputEventType, Class collectionComponentType) {
        this.aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(collectionComponentType);
        return EPTypeHelper.singleValue(JavaClassHelper.getBoxedType(this.aggMethodFactory.getValueType()));
    }

    @Override
    protected ThreeFormNoParamFactory.ForgeFunction noParamsForge(EnumMethodEnum enumMethod, EPType type, StatementCompileTimeServices services) {
        return streamCountIncoming -> new EnumSumScalarNoParams(streamCountIncoming, this.aggMethodFactory);
    }

    @Override
    protected Function<ExprDotEvalParamLambda, EPType> initAndSingleParamReturnType(EventType inputEventType, Class collectionComponentType) {
        return lambda -> {
            this.aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(lambda.getBodyForge().getEvaluationType());
            Class returnType = JavaClassHelper.getBoxedType(this.aggMethodFactory.getValueType());
            return EPTypeHelper.singleValue(returnType);
        };
    }

    @Override
    protected ThreeFormEventPlainFactory.ForgeFunction singleParamEventPlain(EnumMethodEnum enumMethod) {
        return (lambda, typeInfo, services) -> new EnumSumEvent(lambda, this.aggMethodFactory);
    }

    @Override
    protected ThreeFormEventPlusFactory.ForgeFunction singleParamEventPlus(EnumMethodEnum enumMethod) {
        return (lambda, fieldType, numParameters, typeInfo, services) -> new EnumSumEventPlus(lambda, fieldType, numParameters, this.aggMethodFactory);
    }

    @Override
    protected ThreeFormScalarFactory.ForgeFunction singleParamScalar(EnumMethodEnum enumMethod) {
        return (lambda, eventType, numParams, typeInfo, services) -> new EnumSumScalar(lambda, eventType, numParams, this.aggMethodFactory);
    }

    private static ExprDotEvalSumMethodFactory getAggregatorFactory(Class evalType) {
        if (JavaClassHelper.isFloatingPointClass(evalType)) {
            return ExprDotEvalSumMethodFactoryDouble.INSTANCE;
        }
        if (evalType == BigDecimal.class) {
            return ExprDotEvalSumMethodFactoryBigDecimal.INSTANCE;
        }
        if (evalType == BigInteger.class) {
            return ExprDotEvalSumMethodFactoryBigInteger.INSTANCE;
        }
        if (JavaClassHelper.getBoxedType(evalType) == Long.class) {
            return ExprDotEvalSumMethodFactoryLong.INSTANCE;
        }
        return ExprDotEvalSumMethodFactoryInteger.INSTANCE;
    }

    private static void codegenReturnSumOrNull(CodegenBlock block) {
        block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("cnt"), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.ref("sum"));
    }

    private static class ExprDotEvalSumMethodInteger
    implements ExprDotEvalSumMethod {
        protected int sum;
        protected long cnt;

        private ExprDotEvalSumMethodInteger() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Integer)object).intValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryInteger INSTANCE = new ExprDotEvalSumMethodFactoryInteger();

        private ExprDotEvalSumMethodFactoryInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodInteger();
        }

        @Override
        public Class getValueType() {
            return Integer.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Integer.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Integer.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodLong
    implements ExprDotEvalSumMethod {
        protected long sum;
        protected long cnt;

        private ExprDotEvalSumMethodLong() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Long)object).longValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryLong
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryLong INSTANCE = new ExprDotEvalSumMethodFactoryLong();

        private ExprDotEvalSumMethodFactoryLong() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodLong();
        }

        @Override
        public Class getValueType() {
            return Long.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Long.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Long.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodBigInteger
    implements ExprDotEvalSumMethod {
        protected BigInteger sum = BigInteger.valueOf(0L);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigInteger)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigInteger INSTANCE = new ExprDotEvalSumMethodFactoryBigInteger();

        private ExprDotEvalSumMethodFactoryBigInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigInteger();
        }

        @Override
        public Class getValueType() {
            return BigInteger.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(BigInteger.class, "sum", CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.constant(0)));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(BigInteger.class, (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodBigDecimal
    implements ExprDotEvalSumMethod {
        protected BigDecimal sum = new BigDecimal(0.0);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigDecimal)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigDecimal
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigDecimal INSTANCE = new ExprDotEvalSumMethodFactoryBigDecimal();

        private ExprDotEvalSumMethodFactoryBigDecimal() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigDecimal();
        }

        @Override
        public Class getValueType() {
            return BigDecimal.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(BigDecimal.class, "sum", CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0)));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodDouble
    implements ExprDotEvalSumMethod {
        protected double sum;
        protected long cnt;

        private ExprDotEvalSumMethodDouble() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Double)object).doubleValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryDouble
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryDouble INSTANCE = new ExprDotEvalSumMethodFactoryDouble();

        private ExprDotEvalSumMethodFactoryDouble() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodDouble();
        }

        @Override
        public Class getValueType() {
            return Double.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Double.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Double.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }
}

