/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationResultFuture;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeParamDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public abstract class ExprAggregateNodeBase
extends ExprNodeBase
implements ExprEvaluator,
ExprAggregateNode,
ExprForgeInstrumentable {
    protected int column = -1;
    private AggregationForgeFactory aggregationForgeFactory;
    protected ExprAggregateLocalGroupByDesc optionalAggregateLocalGroupByDesc;
    protected ExprNode optionalFilter;
    protected ExprNode[] positionalParams;
    protected CodegenFieldName aggregationResultFutureMemberName;
    protected boolean isDistinct;

    public abstract String getAggregationFunctionName();

    protected abstract boolean isFilterExpressionAsLastParameter();

    protected abstract boolean equalsNodeAggregateMethodOnly(ExprAggregateNode var1);

    protected abstract AggregationForgeFactory validateAggregationChild(ExprValidationContext var1) throws ExprValidationException;

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    protected ExprAggregateNodeBase(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public ExprNode[] getPositionalParams() {
        return this.positionalParams;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.validatePositionals(validationContext);
        this.aggregationForgeFactory = this.validateAggregationChild(validationContext);
        if (!validationContext.isAggregationFutureNameAlreadySet()) {
            this.aggregationResultFutureMemberName = validationContext.getMemberNames().aggregationResultFutureRef();
        } else if (this.aggregationResultFutureMemberName == null) {
            throw new ExprValidationException("Aggregation future not set");
        }
        return null;
    }

    @Override
    public void validatePositionals(ExprValidationContext validationContext) throws ExprValidationException {
        ExprAggregateNodeParamDesc paramDesc = ExprAggregateNodeUtil.getValidatePositionalParams(this.getChildNodes(), true);
        if (validationContext.getStatementRawInfo().getStatementType() == StatementType.CREATE_TABLE && (paramDesc.getOptLocalGroupBy() != null || paramDesc.getOptionalFilter() != null)) {
            throw new ExprValidationException("The 'group_by' and 'filter' parameter is not allowed in create-table statements");
        }
        this.optionalAggregateLocalGroupByDesc = paramDesc.getOptLocalGroupBy();
        this.optionalFilter = paramDesc.getOptionalFilter();
        if (this.optionalAggregateLocalGroupByDesc != null) {
            ExprNodeUtilityValidate.validateNoSpecialsGroupByExpressions(this.optionalAggregateLocalGroupByDesc.getPartitionExpressions());
        }
        if (this.optionalFilter != null) {
            ExprNodeUtilityValidate.validateNoSpecialsGroupByExpressions(new ExprNode[]{this.optionalFilter});
        }
        if (this.optionalFilter != null && this.isFilterExpressionAsLastParameter()) {
            if (paramDesc.getPositionalParams().length > 1) {
                throw new ExprValidationException("Only a single filter expression can be provided");
            }
            this.positionalParams = ExprNodeUtilityMake.addExpression(paramDesc.getPositionalParams(), this.optionalFilter);
        } else {
            this.positionalParams = paramDesc.getPositionalParams();
        }
    }

    @Override
    public AggregationForgeFactory getFactory() {
        if (this.aggregationForgeFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationForgeFactory;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public final Object evaluate(EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        CodegenExpression eval = CodegenExpressionBuilder.exprDotMethod(future, "getValue", CodegenExpressionBuilder.constant(this.column), CodegenExpressionBuilder.exprDotMethod(exprSymbol.getAddExprEvalCtx(parent), "getAgentInstanceId", new CodegenExpression[0]), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
        if (requiredType == Object.class) {
            return eval;
        }
        return CodegenLegoCast.castSafeFromObjectType(this.getEvaluationType(), eval);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprAggValue", requiredType, parent, exprSymbol, codegenClassScope).build();
    }

    @Override
    public Class getEvaluationType() {
        if (this.aggregationForgeFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationForgeFactory.getResultType();
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public final boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprAggregateNode)) {
            return false;
        }
        ExprAggregateNode other = (ExprAggregateNode)node;
        if (other.isDistinct() != this.isDistinct) {
            return false;
        }
        return this.equalsNodeAggregateMethodOnly(other);
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    protected final Class validateNumericChildAllowFilter(boolean hasFilter) throws ExprValidationException {
        Class childType;
        if (this.positionalParams.length == 0 || this.positionalParams.length > 2) {
            throw this.makeExceptionExpectedParamNum(1, 2);
        }
        ExprNode child = this.positionalParams[0];
        if (hasFilter) {
            this.validateFilter(this.positionalParams[1]);
        }
        if (!JavaClassHelper.isNumeric(childType = child.getForge().getEvaluationType())) {
            throw new ExprValidationException("Implicit conversion from datatype '" + (childType == null ? "null" : childType.getSimpleName()) + "' to numeric is not allowed for aggregation function '" + this.getAggregationFunctionName() + "'");
        }
        return childType;
    }

    protected ExprValidationException makeExceptionExpectedParamNum(int lower, int upper) {
        String message = "The '" + this.getAggregationFunctionName() + "' function expects ";
        message = lower == 0 && upper == 0 ? message + "no parameters" : (lower == upper ? message + lower + " parameters" : message + "at least " + lower + " and up to " + upper + " parameters");
        return new ExprValidationException(message);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.getAggregationFunctionName());
        writer.append('(');
        if (this.isDistinct) {
            writer.append("distinct ");
        }
        if (this.getChildNodes().length > 0) {
            this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
            String delimiter = ",";
            for (int i = 1; i < this.getChildNodes().length; ++i) {
                writer.write(delimiter);
                delimiter = ",";
                this.getChildNodes()[i].toEPL(writer, this.getPrecedence(), flags);
            }
        } else if (this.isExprTextWildcardWhenNoParams()) {
            writer.append('*');
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.MINIMUM;
    }

    public void validateFilter(ExprNode filterEvaluator) throws ExprValidationException {
        if (JavaClassHelper.getBoxedType(filterEvaluator.getForge().getEvaluationType()) != Boolean.class) {
            throw new ExprValidationException("Invalid filter expression parameter to the aggregation function '" + this.getAggregationFunctionName() + "' is expected to return a boolean value but returns " + JavaClassHelper.getClassNameFullyQualPretty(filterEvaluator.getForge().getEvaluationType()));
        }
    }

    @Override
    public ExprAggregateLocalGroupByDesc getOptionalLocalGroupBy() {
        return this.optionalAggregateLocalGroupByDesc;
    }

    @Override
    public ExprNode getOptionalFilter() {
        return this.optionalFilter;
    }

    protected boolean isExprTextWildcardWhenNoParams() {
        return true;
    }

    public CodegenExpression getAggFuture(CodegenClassScope codegenClassScope) {
        return codegenClassScope.getPackageScope().addOrGetFieldWellKnown(this.aggregationResultFutureMemberName, AggregationResultFuture.class);
    }
}

