/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.base;

import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeParamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ExprAggregateNodeUtil {
    public static ExprAggregateNodeParamDesc getValidatePositionalParams(ExprNode[] childNodes, boolean builtinAggregationFunc) throws ExprValidationException {
        ExprAggregateLocalGroupByDesc optionalLocalGroupBy = null;
        ExprNode optionalFilter = null;
        int count = 0;
        for (ExprNode node : childNodes) {
            if (!ExprAggregateNodeUtil.isNonPositionalParameter(node)) {
                ++count;
                continue;
            }
            ExprNamedParameterNode namedParameterNode = (ExprNamedParameterNode)((Object)node);
            String paramNameLower = namedParameterNode.getParameterName().toLowerCase(Locale.ENGLISH);
            if (paramNameLower.equals("group_by")) {
                optionalLocalGroupBy = new ExprAggregateLocalGroupByDesc(namedParameterNode.getChildNodes());
                continue;
            }
            if (paramNameLower.equals("filter")) {
                if (namedParameterNode.getChildNodes().length != 1 | JavaClassHelper.getBoxedType(namedParameterNode.getChildNodes()[0].getForge().getEvaluationType()) != Boolean.class) {
                    throw new ExprValidationException("Filter named parameter requires a single expression returning a boolean-typed value");
                }
                optionalFilter = namedParameterNode.getChildNodes()[0];
                continue;
            }
            if (!builtinAggregationFunc) continue;
            throw new ExprValidationException("Invalid named parameter '" + namedParameterNode.getParameterName() + "' (did you mean 'group_by' or 'filter'?)");
        }
        ExprNode[] positionals = new ExprNode[count];
        count = 0;
        for (ExprNode node : childNodes) {
            if (ExprAggregateNodeUtil.isNonPositionalParameter(node)) continue;
            positionals[count++] = node;
        }
        return new ExprAggregateNodeParamDesc(positionals, optionalLocalGroupBy, optionalFilter);
    }

    public static boolean isNonPositionalParameter(ExprNode node) {
        return node instanceof ExprNamedParameterNode;
    }

    public static void getAggregatesBottomUp(ExprNode[][] nodes, List<ExprAggregateNode> aggregateNodes) {
        if (nodes == null) {
            return;
        }
        for (ExprNode[] node : nodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(node, aggregateNodes);
        }
    }

    public static void getAggregatesBottomUp(ExprNode[] nodes, List<ExprAggregateNode> aggregateNodes) {
        if (nodes == null) {
            return;
        }
        for (ExprNode node : nodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(node, aggregateNodes);
        }
    }

    public static void getAggregatesBottomUp(ExprNode topNode, List<ExprAggregateNode> aggregateNodes) {
        int deepLevel;
        TreeMap<Integer, List<ExprAggregateNode>> aggregateExprPerLevel = new TreeMap<Integer, List<ExprAggregateNode>>();
        ExprAggregateNodeUtil.recursiveAggregate(topNode, aggregateExprPerLevel, 1);
        if (aggregateExprPerLevel.isEmpty()) {
            return;
        }
        for (int i = deepLevel = aggregateExprPerLevel.lastKey().intValue(); i >= 1; --i) {
            List<ExprAggregateNode> list = aggregateExprPerLevel.get(i);
            if (list == null) continue;
            aggregateNodes.addAll(list);
        }
    }

    private static void recursiveAggregate(ExprNode topNode, Map<Integer, List<ExprAggregateNode>> aggregateExprPerLevel, int level) {
        ExprAggregateNodeUtil.recursiveAggregateHandleSpecial(topNode, aggregateExprPerLevel, level);
        ExprAggregateNodeUtil.recursiveAggregateEnter(topNode, aggregateExprPerLevel, level);
    }

    private static void recursiveAggregateHandleSpecial(ExprNode topNode, Map<Integer, List<ExprAggregateNode>> aggregateExprPerLevel, int level) {
        if (topNode instanceof ExprNodeInnerNodeProvider) {
            ExprNodeInnerNodeProvider parameterized = (ExprNodeInnerNodeProvider)((Object)topNode);
            List<ExprNode> additionalNodes = parameterized.getAdditionalNodes();
            for (ExprNode additionalNode : additionalNodes) {
                ExprAggregateNodeUtil.recursiveAggregate(additionalNode, aggregateExprPerLevel, level);
            }
        }
        if (topNode instanceof ExprDeclaredNode) {
            ExprDeclaredNode declared = (ExprDeclaredNode)topNode;
            ExprAggregateNodeUtil.recursiveAggregate(declared.getBody(), aggregateExprPerLevel, level);
        }
    }

    private static void recursiveAggregateEnter(ExprNode currentNode, Map<Integer, List<ExprAggregateNode>> aggregateExprPerLevel, int currentLevel) {
        for (ExprNode node : currentNode.getChildNodes()) {
            ExprAggregateNodeUtil.recursiveAggregate(node, aggregateExprPerLevel, currentLevel + 1);
        }
        if (!(currentNode instanceof ExprAggregateNode)) {
            return;
        }
        List<ExprAggregateNode> aggregates = aggregateExprPerLevel.get(currentLevel);
        if (aggregates == null) {
            aggregates = new LinkedList<ExprAggregateNode>();
            aggregateExprPerLevel.put(currentLevel, aggregates);
        }
        aggregates.add((ExprAggregateNode)currentNode);
    }

    public static int countPositionalArgs(List<ExprNode> args) {
        int count = 0;
        for (ExprNode expr : args) {
            if (ExprAggregateNodeUtil.isNonPositionalParameter(expr)) continue;
            ++count;
        }
        return count;
    }
}

