/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.method;

import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.minmax.AggregationForgeFactoryMinMax;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityAggregation;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.MinMaxTypeEnum;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;

public class ExprMinMaxAggrNode
extends ExprAggregateNodeBase {
    private final MinMaxTypeEnum minMaxTypeEnum;
    private final boolean isFFunc;
    private final boolean isEver;
    private boolean hasFilter;

    public ExprMinMaxAggrNode(boolean distinct, MinMaxTypeEnum minMaxTypeEnum, boolean isFFunc, boolean isEver) {
        super(distinct);
        this.minMaxTypeEnum = minMaxTypeEnum;
        this.isFFunc = isFFunc;
        this.isEver = isEver;
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length == 0 || this.positionalParams.length > 2) {
            throw new ExprValidationException(this.minMaxTypeEnum.toString() + " node must have either 1 or 2 parameters");
        }
        ExprNode child = this.positionalParams[0];
        boolean hasDataWindows = this.isEver ? false : (validationContext.getStatementType() == StatementType.CREATE_TABLE ? true : ExprNodeUtilityAggregation.hasRemoveStreamForAggregations(child, validationContext.getStreamTypeService(), validationContext.isResettingAggregations()));
        if (this.isFFunc) {
            if (this.positionalParams.length < 2) {
                throw new ExprValidationException(this.minMaxTypeEnum.toString() + "-filtered aggregation function must have a filter expression as a second parameter");
            }
            super.validateFilter(this.positionalParams[1]);
        }
        boolean bl = this.hasFilter = this.positionalParams.length == 2;
        if (this.hasFilter) {
            this.optionalFilter = this.positionalParams[1];
        }
        Class evaluationType = child.getForge().getEvaluationType();
        DataInputOutputSerdeForge serde = validationContext.getSerdeResolver().serdeForAggregation(evaluationType, validationContext.getStatementRawInfo());
        DataInputOutputSerdeForge distinctSerde = this.isDistinct ? validationContext.getSerdeResolver().serdeForAggregationDistinct(evaluationType, validationContext.getStatementRawInfo()) : null;
        return new AggregationForgeFactoryMinMax(this, evaluationType, hasDataWindows, serde, distinctSerde);
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprMinMaxAggrNode)) {
            return false;
        }
        ExprMinMaxAggrNode other = (ExprMinMaxAggrNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum && other.isEver == this.isEver;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    public boolean isHasFilter() {
        return this.hasFilter;
    }

    @Override
    public String getAggregationFunctionName() {
        return this.minMaxTypeEnum.getExpressionText();
    }

    public boolean isEver() {
        return this.isEver;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return true;
    }
}

