/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.chain;

import com.espertech.esper.common.internal.epl.expression.chain.ChainableName;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Chainable {
    private final boolean distinct;
    private final boolean optional;

    public abstract void addParametersTo(Collection<ExprNode> var1);

    public abstract void accept(ExprNodeVisitor var1);

    public abstract void accept(ExprNodeVisitorWithParent var1);

    public abstract void accept(ExprNodeVisitorWithParent var1, ExprNode var2);

    public abstract String getRootNameOrEmptyString();

    public abstract List<ExprNode> getParametersOrEmpty();

    public abstract void validateExpressions(ExprNodeOrigin var1, ExprValidationContext var2) throws ExprValidationException;

    public Chainable() {
        this(false, false);
    }

    public Chainable(boolean distinct, boolean optional) {
        this.distinct = distinct;
        this.optional = optional;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public static boolean isPlainPropertyChain(Chainable chainable) {
        return chainable instanceof ChainableName && chainable.getRootNameOrEmptyString().contains(".");
    }

    public void validate(ExprNodeOrigin origin, ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprNode node : this.getParametersOrEmpty()) {
            if (!(node instanceof ExprNamedParameterNode)) continue;
            throw new ExprValidationException("Named parameters are not allowed");
        }
        this.validateExpressions(origin, validationContext);
    }

    public static List<Chainable> chainForDot(Chainable chainable) {
        if (!(chainable instanceof ChainableName)) {
            return new ArrayList<Chainable>(Collections.singletonList(chainable));
        }
        String[] values = chainable.getRootNameOrEmptyString().split("\\.");
        ArrayList<Chainable> chain = new ArrayList<Chainable>(values.length + 1);
        for (String value : values) {
            chain.add(new ChainableName(value));
        }
        return chain;
    }

    protected static void validateExpressions(List<ExprNode> expressions, ExprNodeOrigin origin, ExprValidationContext validationContext) throws ExprValidationException {
        for (int i = 0; i < expressions.size(); ++i) {
            ExprNode validated;
            ExprNode node = expressions.get(i);
            if (node == (validated = ExprNodeUtilityValidate.getValidatedSubtree(origin, node, validationContext))) continue;
            expressions.set(i, validated);
        }
    }

    protected boolean equalsChainable(Chainable that) {
        return that.distinct == this.distinct && that.optional == this.optional;
    }
}

