/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.chain;

import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class ChainableArray
extends Chainable {
    private List<ExprNode> indexes;

    public ChainableArray(List<ExprNode> indexExpressions) {
        this.indexes = indexExpressions;
    }

    public ChainableArray(boolean distinct, boolean optional, List<ExprNode> indexes) {
        super(distinct, optional);
        this.indexes = indexes;
    }

    public List<ExprNode> getIndexes() {
        return this.indexes;
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.indexes);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.indexes);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.indexes, parent);
    }

    @Override
    public List<ExprNode> getParametersOrEmpty() {
        return Collections.emptyList();
    }

    @Override
    public void validateExpressions(ExprNodeOrigin origin, ExprValidationContext validationContext) throws ExprValidationException {
        ChainableArray.validateExpressions(this.indexes, origin, validationContext);
    }

    @Override
    public String getRootNameOrEmptyString() {
        return "";
    }

    @Override
    public void addParametersTo(Collection<ExprNode> result) {
        result.addAll(this.indexes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainableArray that = (ChainableArray)o;
        return super.equalsChainable(that) && ExprNodeUtilityCompare.deepEquals(this.indexes, that.indexes);
    }

    public int hashCode() {
        return 0;
    }

    public static ExprNode validateSingleIndexExpr(List<ExprNode> indexes, Supplier<String> supplier) throws ExprValidationException {
        if (indexes.size() != 1) {
            throw new ExprValidationException("Incorrect number of index expressions for array operation, expected a single expression returning an integer value but received " + indexes.size() + " expressions for " + supplier.get());
        }
        ExprNode node = indexes.get(0);
        Class evaluationType = node.getForge().getEvaluationType();
        if (JavaClassHelper.getBoxedType(evaluationType) != Integer.class) {
            throw new ExprValidationException("Incorrect index expression for array operation, expected an expression returning an integer value but the expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(node) + "' returns '" + JavaClassHelper.getClassNameFullyQualPretty(evaluationType) + "' for " + supplier.get());
        }
        return node;
    }
}

