/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;

public class CodegenLegoBooleanExpression {
    private static final String PASS_NAME = "pass";

    public static void codegenReturnBoolIfNullOrBool(CodegenBlock block, Class evaluationType, CodegenExpression expression, boolean earlyExitIfNull, Boolean resultEarlyExit, boolean checkFor, boolean resultIfCheckPasses) {
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        block.declareVar(evaluationType, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.notOptional(!checkFor, CodegenExpressionBuilder.ref(PASS_NAME));
        if (evaluationType.isPrimitive()) {
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        if (earlyExitIfNull) {
            if (resultEarlyExit == null) {
                throw new IllegalStateException("Invalid null for result-early-exit");
            }
            block.ifRefNull(PASS_NAME).blockReturn(CodegenExpressionBuilder.constant(resultEarlyExit));
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        block.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
    }

    public static void codegenReturnValueIfNotNullAndNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, CodegenExpression value) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, false, false, value);
    }

    public static void codegenReturnValueIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, CodegenExpression value) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, false, false, value);
    }

    public static void codegenBreakIfNotNullAndNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, false, true, CodegenExpressionBuilder.constantNull());
    }

    public static void codegenContinueIfNotNullAndNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, true, false, CodegenExpressionBuilder.constantNull());
    }

    public static void codegenContinueIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, true, false, CodegenExpressionBuilder.constantNull());
    }

    private static void codegenDoIfNotNullAndNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, boolean doContinue, boolean doBreakLoop, CodegenExpression returnValue) {
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        block.declareVar(evaluationType, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(PASS_NAME));
        CodegenExpression condition = evaluationType.isPrimitive() ? passCheck : CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0]);
        if (doContinue) {
            block.ifCondition(condition).blockContinue();
        } else if (doBreakLoop) {
            block.ifCondition(condition).breakLoop();
        } else {
            block.ifCondition(condition).blockReturn(returnValue);
        }
    }

    private static void codegenDoIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, boolean doContinue, boolean doBreakLoop, CodegenExpression returnValue) {
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        block.declareVar(evaluationType, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(PASS_NAME));
        CodegenExpression condition = evaluationType.isPrimitive() ? passCheck : CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0]);
        if (doContinue) {
            block.ifCondition(condition).blockContinue();
        } else if (doBreakLoop) {
            block.ifCondition(condition).breakLoop();
        } else {
            block.ifCondition(condition).blockReturn(returnValue);
        }
    }
}

