/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;

public class CodegenLegoCast {
    public static CodegenExpression castSafeFromObjectType(Class targetType, CodegenExpression value) {
        if (targetType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (targetType == Object.class) {
            return value;
        }
        if (targetType == Void.TYPE) {
            throw new IllegalArgumentException("Invalid void target type for cast");
        }
        if (targetType.isPrimitive()) {
            return CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(targetType), value);
        }
        return CodegenExpressionBuilder.cast(targetType, value);
    }

    public static void asDoubleNullReturnNull(CodegenBlock block, String variable, ExprForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class type = forge.getEvaluationType();
        if (type == Double.TYPE) {
            block.declareVar(type, variable, forge.evaluateCodegen(type, codegenMethodScope, exprSymbol, codegenClassScope));
            return;
        }
        String holder = variable + "_";
        block.declareVar(type, holder, forge.evaluateCodegen(type, codegenMethodScope, exprSymbol, codegenClassScope));
        if (!type.isPrimitive()) {
            block.ifRefNullReturnNull(holder);
        }
        block.declareVar(Double.TYPE, variable, SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(CodegenExpressionBuilder.ref(holder), type));
    }
}

