/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluator;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprFilterSpecLookupable {
    private final String expression;
    private final transient ExprEventEvaluator eval;
    private final Class returnType;
    private final boolean isNonPropertyEval;
    private final DataInputOutputSerde<Object> valueSerde;
    private final transient ExprEvaluator expr;

    public ExprFilterSpecLookupable(String expression, ExprEventEvaluator eval, ExprEvaluator expr, Class returnType, boolean isNonPropertyEval, DataInputOutputSerde<Object> valueSerde) {
        this.expression = expression;
        this.eval = eval;
        this.expr = expr;
        this.returnType = JavaClassHelper.getBoxedType(returnType);
        this.isNonPropertyEval = isNonPropertyEval;
        this.valueSerde = valueSerde;
    }

    public String getExpression() {
        return this.expression;
    }

    public ExprEventEvaluator getEval() {
        return this.eval;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprFilterSpecLookupable that = (ExprFilterSpecLookupable)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public void appendTo(StringWriter writer) {
        writer.append(this.expression);
    }

    public String toString() {
        return "ExprFilterSpecLookupable{expression='" + this.expression + '\'' + '}';
    }

    public boolean isNonPropertyEval() {
        return this.isNonPropertyEval;
    }

    public DataInputOutputSerde<Object> getValueSerde() {
        return this.valueSerde;
    }

    public ExprFilterSpecLookupable make(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        return this;
    }

    public ExprEvaluator getExpr() {
        return this.expr;
    }
}

