/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ExprForgeProxy
implements InvocationHandler {
    private static final Method TARGET_EVALUATECODEGEN = JavaClassHelper.getMethodByName(ExprForge.class, "evaluateCodegen");
    private final String expressionToString;
    private final ExprForge forge;

    public static Object newInstance(String expressionToString, ExprForge forge) {
        return Proxy.newProxyInstance(forge.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(forge.getClass()), (InvocationHandler)new ExprForgeProxy(expressionToString, forge));
    }

    public ExprForgeProxy(String expressionToString, ExprForge forge) {
        this.expressionToString = expressionToString;
        this.forge = forge;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (m.equals(TARGET_EVALUATECODEGEN)) {
                Class evaluationType = this.forge.getEvaluationType();
                Class requiredType = (Class)args[args.length - 4];
                CodegenMethodScope parent = (CodegenMethodScope)args[args.length - 3];
                ExprForgeCodegenSymbol symbols = (ExprForgeCodegenSymbol)args[args.length - 2];
                CodegenClassScope codegenClassScope = (CodegenClassScope)args[args.length - 1];
                if (evaluationType == null) {
                    return this.forge.evaluateCodegen(requiredType, parent, symbols, codegenClassScope);
                }
                CodegenMethod method = parent.makeChild(evaluationType, ExprForgeProxy.class, (CodegenScope)codegenClassScope);
                if (evaluationType == Void.TYPE) {
                    method.getBlock().expression(this.forge.evaluateCodegen(requiredType, method, symbols, codegenClassScope)).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddExprEvalCtx(method)).add("getAuditProvider", new CodegenExpression[0]).add("expression", CodegenExpressionBuilder.constant(this.expressionToString), CodegenExpressionBuilder.constant("(void)"), symbols.getAddExprEvalCtx(method))).methodEnd();
                } else {
                    method.getBlock().declareVar(evaluationType, "result", this.forge.evaluateCodegen(evaluationType, method, symbols, codegenClassScope)).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddExprEvalCtx(method)).add("getAuditProvider", new CodegenExpression[0]).add("expression", CodegenExpressionBuilder.constant(this.expressionToString), CodegenExpressionBuilder.ref("result"), symbols.getAddExprEvalCtx(method))).methodReturn(CodegenExpressionBuilder.ref("result"));
                }
                return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
            }
            return m.invoke((Object)this.forge, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        if (TARGET_EVALUATECODEGEN == null) {
            throw new RuntimeException("Failed to find required methods");
        }
    }
}

