/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;

public class ExprIdentNodeEvaluatorContext
implements ExprIdentNodeEvaluator {
    private final int streamNum;
    private final Class resultType;
    private final EventPropertyGetterSPI getter;
    private final EventTypeSPI eventType;

    public ExprIdentNodeEvaluatorContext(int streamNum, Class resultType, EventPropertyGetterSPI getter, EventTypeSPI eventType) {
        this.streamNum = streamNum;
        this.resultType = resultType;
        this.getter = getter;
        this.eventType = eventType;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        return true;
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (context.getContextProperties() != null) {
            return this.getter.get(context.getContextProperties());
        }
        return null;
    }

    @Override
    public CodegenExpression codegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(this.resultType, this.getClass(), (CodegenScope)codegenClassScope);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(methodNode);
        methodNode.getBlock().ifCondition(CodegenExpressionBuilder.notEqualsNull(refExprEvalCtx)).blockReturn(CodegenLegoCast.castSafeFromObjectType(this.resultType, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.exprDotMethod(refExprEvalCtx, "getContextProperties", new CodegenExpression[0]), methodNode, codegenClassScope))).methodReturn(CodegenExpressionBuilder.constantNull());
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Class getEvaluationType() {
        return this.resultType;
    }

    @Override
    public EventPropertyGetterSPI getGetter() {
        return this.getter;
    }

    @Override
    public boolean isContextEvaluated() {
        return true;
    }

    @Override
    public void setOptionalEvent(boolean optionalEvent) {
    }

    @Override
    public EventTypeSPI getEventType() {
        return this.eventType;
    }
}

