/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeProxy;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ExprNodeProxy
implements InvocationHandler {
    private static final Method TARGET_GETFORGE = JavaClassHelper.getMethodByName(ExprNode.class, "getForge");
    private static final Method TARGET_EQUALSNODE = JavaClassHelper.getMethodByName(ExprNode.class, "equalsNode");
    private ExprNode exprNode;

    public static Object newInstance(ExprNode exprNode) {
        return Proxy.newProxyInstance(exprNode.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(exprNode.getClass()), (InvocationHandler)new ExprNodeProxy(exprNode));
    }

    public ExprNodeProxy(ExprNode exprNode) {
        this.exprNode = exprNode;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (m.equals(TARGET_GETFORGE)) {
                return this.handleGetForge(m, args);
            }
            if (m.equals(TARGET_EQUALSNODE)) {
                return this.handleEqualsNode(m, args);
            }
            return m.invoke((Object)this.exprNode, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public ExprNode getOriginalObject() {
        return this.exprNode;
    }

    private Object handleEqualsNode(Method m, Object[] args) {
        ExprNode otherNode;
        try {
            otherNode = ((ExprNodeProxy)Proxy.getInvocationHandler(args[0])).getOriginalObject();
        }
        catch (IllegalArgumentException ex) {
            otherNode = (ExprNode)args[0];
        }
        return this.exprNode.equalsNode(otherNode, (Boolean)args[1]);
    }

    private Object handleGetForge(Method m, Object[] args) throws Exception {
        String expressionToString = "undefined";
        try {
            expressionToString = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.exprNode);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ExprForge forge = (ExprForge)m.invoke((Object)this.exprNode, args);
        return ExprForgeProxy.newInstance(expressionToString, forge);
    }

    static {
        if (TARGET_GETFORGE == null || TARGET_EQUALSNODE == null) {
            throw new RuntimeException("Failed to find required methods");
        }
    }
}

