/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEvent;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExprNodeUtilityCodegen {
    public static CodegenExpression codegenExpressionMayCoerce(ExprForge forge, Class targetType, CodegenMethod exprMethod, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope classScope) {
        CodegenExpression expr = forge.evaluateCodegen(forge.getEvaluationType(), exprMethod, exprSymbol, classScope);
        return ExprNodeUtilityCodegen.codegenCoerce(expr, forge.getEvaluationType(), targetType, false);
    }

    public static CodegenExpression codegenCoerce(CodegenExpression expression, Class exprType, Class targetType, boolean alwaysCast) {
        if (targetType == null) {
            return expression;
        }
        if (JavaClassHelper.getBoxedType(exprType) == JavaClassHelper.getBoxedType(targetType)) {
            return alwaysCast ? CodegenExpressionBuilder.cast(targetType, expression) : expression;
        }
        SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(exprType, JavaClassHelper.getBoxedType(targetType));
        if (exprType.isPrimitive() || alwaysCast) {
            expression = CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(exprType), expression);
        }
        return coercer.coerceCodegen(expression, exprType);
    }

    public static CodegenExpressionNewAnonymousClass codegenEvaluator(ExprForge forge, CodegenMethod method, Class originator, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass anonymousClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEvaluator.class);
        CodegenMethod evaluate = CodegenMethod.makeParentNode(Object.class, originator, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        anonymousClass.addMethod("evaluate", evaluate);
        if (forge.getEvaluationType() == null) {
            evaluate.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        } else if (forge.getEvaluationType() == Void.TYPE) {
            CodegenMethod evalMethod = CodegenLegoMethodExpression.codegenExpression(forge, method, classScope);
            evaluate.getBlock().localMethod(evalMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT).methodReturn(CodegenExpressionBuilder.constantNull());
        } else {
            CodegenMethod evalMethod = CodegenLegoMethodExpression.codegenExpression(forge, method, classScope);
            evaluate.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(evalMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        }
        return anonymousClass;
    }

    public static CodegenExpression codegenEvaluators(ExprNode[] expressions, CodegenMethodScope parent, Class originator, CodegenClassScope classScope) {
        return ExprNodeUtilityCodegen.codegenEvaluators(ExprNodeUtilityQuery.getForges(expressions), parent, originator, classScope);
    }

    public static CodegenExpression codegenEvaluators(ExprForge[][] expressions, CodegenMethodScope parent, Class originator, CodegenClassScope classScope) {
        CodegenExpression[] init = new CodegenExpression[expressions.length];
        for (int i = 0; i < init.length; ++i) {
            init[i] = ExprNodeUtilityCodegen.codegenEvaluators(expressions[i], parent, originator, classScope);
        }
        return CodegenExpressionBuilder.newArrayWithInit(ExprEvaluator[].class, init);
    }

    public static CodegenExpression codegenEvaluators(ExprForge[] expressions, CodegenMethodScope parent, Class originator, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(ExprEvaluator[].class, originator, (CodegenScope)classScope);
        method.getBlock().declareVar(ExprEvaluator[].class, "evals", CodegenExpressionBuilder.newArrayByLength(ExprEvaluator.class, CodegenExpressionBuilder.constant(expressions.length)));
        for (int i = 0; i < expressions.length; ++i) {
            method.getBlock().assignArrayElement("evals", CodegenExpressionBuilder.constant(i), expressions[i] == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(expressions[i], method, originator, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("evals"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public static CodegenExpressionNewAnonymousClass codegenEvaluatorNoCoerce(ExprForge forge, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        return ExprNodeUtilityCodegen.codegenEvaluatorWCoerce(forge, null, method, generator, classScope);
    }

    public static CodegenExpressionNewAnonymousClass codegenEvaluatorWCoerce(ExprForge forge, Class optCoercionType, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass evaluator = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEvaluator.class);
        CodegenMethod evaluate = CodegenMethod.makeParentNode(Object.class, generator, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        evaluator.addMethod("evaluate", evaluate);
        CodegenExpression result = CodegenExpressionBuilder.constantNull();
        if (forge.getEvaluationType() != null) {
            CodegenMethod evalMethod = CodegenLegoMethodExpression.codegenExpression(forge, method, classScope);
            result = CodegenExpressionBuilder.localMethod(evalMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            if (optCoercionType != null && JavaClassHelper.getBoxedType(forge.getEvaluationType()) != JavaClassHelper.getBoxedType(optCoercionType)) {
                SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(forge.getEvaluationType(), JavaClassHelper.getBoxedType(optCoercionType));
                evaluate.getBlock().declareVar(forge.getEvaluationType(), "result", result);
                result = coercer.coerceCodegen(CodegenExpressionBuilder.ref("result"), forge.getEvaluationType());
            }
        }
        evaluate.getBlock().methodReturn(result);
        return evaluator;
    }

    public static CodegenExpressionNewAnonymousClass codegenEvaluatorObjectArray(ExprForge[] forges, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        int i;
        CodegenExpressionNewAnonymousClass evaluator = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEvaluator.class);
        CodegenMethod evaluate = CodegenMethod.makeParentNode(Object.class, generator, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        evaluator.addMethod("evaluate", evaluate);
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = evaluate.makeChildWithScope(Object.class, CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression[] expressions = new CodegenExpression[forges.length];
        for (i = 0; i < forges.length; ++i) {
            expressions[i] = forges[i].evaluateCodegen(forges[i].getEvaluationType(), exprMethod, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(evaluate, exprMethod.getBlock(), classScope);
        exprMethod.getBlock().declareVar(Object[].class, "values", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(forges.length)));
        for (i = 0; i < forges.length; ++i) {
            CodegenExpression result = expressions[i];
            exprMethod.getBlock().assignArrayElement("values", CodegenExpressionBuilder.constant(i), result);
        }
        exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("values"));
        evaluate.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        return evaluator;
    }

    public static CodegenMethod codegenMapSelect(ExprNode[] selectClause, String[] selectAsNames, Class generator, CodegenMethodScope parent, CodegenClassScope classScope) {
        int i;
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod method = parent.makeChildWithScope(Map.class, generator, exprSymbol, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        method.getBlock().declareVar(Map.class, "map", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(selectAsNames.length + 2)));
        CodegenExpression[] expressions = new CodegenExpression[selectAsNames.length];
        for (i = 0; i < selectClause.length; ++i) {
            expressions[i] = selectClause[i].getForge().evaluateCodegen(Object.class, method, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(method, method.getBlock(), classScope);
        for (i = 0; i < selectClause.length; ++i) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("map"), "put", CodegenExpressionBuilder.constant(selectAsNames[i]), expressions[i]);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("map"));
        return method;
    }

    public static CodegenExpression codegenExprEnumEval(ExprEnumerationGivenEventForge enumEval, CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope, Class generator) {
        CodegenExpressionNewAnonymousClass evaluator = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEnumerationGivenEvent.class);
        ExprEnumerationGivenEventSymbol enumSymbols = new ExprEnumerationGivenEventSymbol();
        CodegenMethod evaluateEventGetROCollectionEvents = CodegenMethod.makeParentNode(Collection.class, generator, (CodegenSymbolProvider)enumSymbols, (CodegenScope)classScope).addParam(EventBean.class, "event").addParam(ExprEvaluatorContext.class, "exprEvalCtx");
        evaluator.addMethod("evaluateEventGetROCollectionEvents", evaluateEventGetROCollectionEvents);
        evaluateEventGetROCollectionEvents.getBlock().methodReturn(enumEval.evaluateEventGetROCollectionEventsCodegen(evaluateEventGetROCollectionEvents, enumSymbols, classScope));
        CodegenMethod evaluateEventGetROCollectionScalar = CodegenMethod.makeParentNode(Collection.class, generator, (CodegenSymbolProvider)enumSymbols, (CodegenScope)classScope).addParam(EventBean.class, "event").addParam(ExprEvaluatorContext.class, "exprEvalCtx");
        evaluator.addMethod("evaluateEventGetROCollectionScalar", evaluateEventGetROCollectionScalar);
        evaluateEventGetROCollectionScalar.getBlock().methodReturn(enumEval.evaluateEventGetROCollectionScalarCodegen(evaluateEventGetROCollectionScalar, enumSymbols, classScope));
        CodegenMethod evaluateEventGetEventBean = CodegenMethod.makeParentNode(EventBean.class, generator, (CodegenSymbolProvider)enumSymbols, (CodegenScope)classScope).addParam(EventBean.class, "event").addParam(ExprEvaluatorContext.class, "exprEvalCtx");
        evaluator.addMethod("evaluateEventGetEventBean", evaluateEventGetEventBean);
        evaluateEventGetEventBean.getBlock().methodReturn(enumEval.evaluateEventGetEventBeanCodegen(evaluateEventGetEventBean, enumSymbols, classScope));
        return evaluator;
    }
}

