/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedClasspathExtension;
import com.espertech.esper.common.internal.epl.enummethod.compile.EnumMethodCallStackHelperImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationMemberName;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCompileTime;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class ExprValidationContext {
    private final StreamTypeService streamTypeService;
    private final ViewResourceDelegateExpr viewResourceDelegate;
    private final ContextCompileTimeDescriptor contextDescriptor;
    private final boolean disablePropertyExpressionEventCollCache;
    private final boolean allowRollupFunctions;
    private final boolean allowBindingConsumption;
    private final boolean allowTableAggReset;
    private final boolean isResettingAggregations;
    private final boolean isExpressionNestedAudit;
    private final boolean isExpressionAudit;
    private final String intoTableName;
    private final boolean isFilterExpression;
    private final ExprValidationMemberName memberName;
    private final boolean aggregationFutureNameAlreadySet;
    private final StatementRawInfo statementRawInfo;
    private final StatementCompileTimeServices compileTimeServices;
    private final List<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);

    public ExprValidationContext(StreamTypeService streamTypeService, ExprValidationContext ctx) {
        this(streamTypeService, ctx.getViewResourceDelegate(), ctx.contextDescriptor, ctx.disablePropertyExpressionEventCollCache, ctx.allowRollupFunctions, ctx.allowBindingConsumption, ctx.allowTableAggReset, ctx.isResettingAggregations, ctx.intoTableName, ctx.isFilterExpression, ctx.memberName, ctx.aggregationFutureNameAlreadySet, ctx.statementRawInfo, ctx.compileTimeServices);
    }

    protected ExprValidationContext(StreamTypeService streamTypeService, ViewResourceDelegateExpr viewResourceDelegate, ContextCompileTimeDescriptor contextDescriptor, boolean disablePropertyExpressionEventCollCache, boolean allowRollupFunctions, boolean allowBindingConsumption, boolean allowTableAggReset, boolean isUnidirectionalJoin, String intoTableName, boolean isFilterExpression, ExprValidationMemberName memberName, boolean aggregationFutureNameAlreadySet, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        this.streamTypeService = streamTypeService;
        this.viewResourceDelegate = viewResourceDelegate;
        this.contextDescriptor = contextDescriptor;
        this.disablePropertyExpressionEventCollCache = disablePropertyExpressionEventCollCache;
        this.allowRollupFunctions = allowRollupFunctions;
        this.allowBindingConsumption = allowBindingConsumption;
        this.allowTableAggReset = allowTableAggReset;
        this.isResettingAggregations = isUnidirectionalJoin;
        this.intoTableName = intoTableName;
        this.isFilterExpression = isFilterExpression;
        this.memberName = memberName;
        this.aggregationFutureNameAlreadySet = aggregationFutureNameAlreadySet;
        this.statementRawInfo = statementRawInfo;
        this.compileTimeServices = compileTimeServices;
        this.isExpressionAudit = AuditEnum.EXPRESSION.getAudit(statementRawInfo.getAnnotations()) != null;
        this.isExpressionNestedAudit = AuditEnum.EXPRESSION_NESTED.getAudit(statementRawInfo.getAnnotations()) != null;
    }

    public Annotation[] getAnnotations() {
        return this.statementRawInfo.getAnnotations();
    }

    public StreamTypeService getStreamTypeService() {
        return this.streamTypeService;
    }

    public ContextCompileTimeDescriptor getContextDescriptor() {
        return this.statementRawInfo.getOptionalContextDescriptor();
    }

    public boolean isFilterExpression() {
        return this.isFilterExpression;
    }

    public ClasspathImportServiceCompileTime getClasspathImportService() {
        return this.compileTimeServices.getClasspathImportServiceCompileTime();
    }

    public ClassProvidedClasspathExtension getClassProvidedClasspathExtension() {
        return this.compileTimeServices.getClassProvidedClasspathExtension();
    }

    public VariableCompileTimeResolver getVariableCompileTimeResolver() {
        return this.compileTimeServices.getVariableCompileTimeResolver();
    }

    public TableCompileTimeResolver getTableCompileTimeResolver() {
        return this.compileTimeServices.getTableCompileTimeResolver();
    }

    public String getStatementName() {
        return this.statementRawInfo.getStatementName();
    }

    public boolean isDisablePropertyExpressionEventCollCache() {
        return this.disablePropertyExpressionEventCollCache;
    }

    public ViewResourceDelegateExpr getViewResourceDelegate() {
        return this.viewResourceDelegate;
    }

    public ExprValidationMemberName getMemberNames() {
        return this.memberName;
    }

    public StatementType getStatementType() {
        return this.statementRawInfo.getStatementType();
    }

    public boolean isResettingAggregations() {
        return this.isResettingAggregations;
    }

    public boolean isAllowRollupFunctions() {
        return this.allowRollupFunctions;
    }

    public StatementCompileTimeServices getStatementCompileTimeService() {
        return this.compileTimeServices;
    }

    public StatementRawInfo getStatementRawInfo() {
        return this.statementRawInfo;
    }

    public boolean isAllowBindingConsumption() {
        return this.allowBindingConsumption;
    }

    public EnumMethodCallStackHelperImpl getEnumMethodCallStackHelper() {
        return this.compileTimeServices.getEnumMethodCallStackHelper();
    }

    public boolean isAggregationFutureNameAlreadySet() {
        return this.aggregationFutureNameAlreadySet;
    }

    public boolean isExpressionNestedAudit() {
        return this.isExpressionNestedAudit;
    }

    public boolean isExpressionAudit() {
        return this.isExpressionAudit;
    }

    public EventBeanTypedEventFactory getEventBeanTypedEventFactory() {
        return EventBeanTypedEventFactoryCompileTime.INSTANCE;
    }

    public String getModuleName() {
        return this.statementRawInfo.getModuleName();
    }

    public SerdeCompileTimeResolver getSerdeResolver() {
        return this.compileTimeServices.getSerdeResolver();
    }

    public SerdeEventTypeCompileTimeRegistry getSerdeEventTypeRegistry() {
        return this.compileTimeServices.getSerdeEventTypeRegistry();
    }

    public List<StmtClassForgeableFactory> getAdditionalForgeables() {
        return this.additionalForgeables;
    }

    public boolean isAllowTableAggReset() {
        return this.allowTableAggReset;
    }
}

