/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.declared.compiletime;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDeclaredOrLambdaNode;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForgeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForgeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluatorForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeBase;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeConstant;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeNoRewrite;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeRewrite;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeRewriteWValue;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentVisitorWParent;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExprDeclaredNodeImpl
extends ExprNodeBase
implements ExprDeclaredNode,
ExprDeclaredOrLambdaNode,
ExprFilterOptimizableNode,
ExprNodeInnerNodeProvider,
ExprConstantNode {
    private static final String INTERNAL_VALUE_STREAMNAME = "esper_declared_expr_internal";
    private final ExpressionDeclItem prototypeWVisibility;
    private List<ExprNode> chainParameters;
    private transient ExprForge forge;
    private ExprNode expressionBodyCopy;
    private transient ExprValidationContext exprValidationContext;
    private boolean allStreamIdsMatch;

    public ExprDeclaredNodeImpl(ExpressionDeclItem prototype, List<ExprNode> chainParameters, ContextCompileTimeDescriptor contextDescriptor, ExprNode expressionBodyCopy) {
        this.prototypeWVisibility = prototype;
        this.chainParameters = chainParameters;
        this.expressionBodyCopy = expressionBodyCopy;
        if (contextDescriptor == null) {
            return;
        }
        ExprNodeIdentVisitorWParent visitorWParent = new ExprNodeIdentVisitorWParent();
        expressionBodyCopy.accept(visitorWParent);
        for (Pair<ExprNode, ExprIdentNode> pair : visitorWParent.getIdentNodes()) {
            String streamOrProp = pair.getSecond().getStreamOrPropertyName();
            if (streamOrProp == null || !contextDescriptor.getContextPropertyRegistry().isContextPropertyPrefix(streamOrProp)) continue;
            ExprContextPropertyNodeImpl context = new ExprContextPropertyNodeImpl(pair.getSecond().getUnresolvedPropertyName());
            if (pair.getFirst() == null) {
                this.expressionBodyCopy = context;
                continue;
            }
            ExprNodeUtilityModify.replaceChildNode(pair.getFirst(), pair.getSecond(), context);
        }
    }

    @Override
    public ExprForge getForge() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode getBody() {
        return this.expressionBodyCopy;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return this.chainParameters;
    }

    @Override
    public boolean validated() {
        return this.forge != null;
    }

    @Override
    public Class getConstantType() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge.getEvaluationType();
    }

    @Override
    public Object getConstantValue() {
        return this.forge.getExprEvaluator().evaluate(null, true, null);
    }

    @Override
    public LinkedHashMap<String, Integer> getOuterStreamNames(Map<String, Integer> outerStreamNames) throws ExprValidationException {
        this.checkParameterCount();
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        LinkedHashMap<String, Integer> streamParameters = new LinkedHashMap<String, Integer>();
        for (int param = 0; param < this.chainParameters.size(); ++param) {
            if (!(this.chainParameters.get(param) instanceof ExprIdentNode)) {
                throw new ExprValidationException("Sub-selects in an expression declaration require passing only stream names as parameters");
            }
            String parameterName = ((ExprIdentNode)this.chainParameters.get(param)).getUnresolvedPropertyName();
            Integer streamIdFound = outerStreamNames.get(parameterName);
            if (streamIdFound == null) {
                throw new ExprValidationException("Failed validation of expression declaration '" + prototype.getName() + "': Invalid parameter to expression declaration, parameter " + param + " is not the name of a stream in the query");
            }
            String prototypeName = prototype.getParametersNames()[param];
            streamParameters.put(prototypeName, streamIdFound);
        }
        return streamParameters;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.exprValidationContext = validationContext;
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        if (prototype.isAlias()) {
            if (!this.chainParameters.isEmpty()) {
                throw new ExprValidationException("Expression '" + prototype.getName() + " is an expression-alias and does not allow parameters");
            }
            try {
                this.expressionBodyCopy = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.ALIASEXPRBODY, this.expressionBodyCopy, validationContext);
            }
            catch (ExprValidationException ex) {
                String message = "Failed to validate expression alias '" + prototype.getName() + "': " + ex.getMessage();
                throw new ExprValidationException(message, ex);
            }
            this.forge = this.expressionBodyCopy.getForge();
            return null;
        }
        if (this.forge != null) {
            return null;
        }
        if (this.getChildNodes().length > 0) {
            throw new IllegalStateException("Execution node has its own child nodes");
        }
        ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
        for (ExprNode expr : this.chainParameters) {
            validated.add(ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRPARAM, expr, validationContext));
        }
        this.chainParameters = validated;
        this.checkParameterCount();
        ArrayList<Integer> valueParameters = new ArrayList<Integer>();
        ArrayList<Integer> eventParameters = new ArrayList<Integer>();
        for (int i = 0; i < prototype.getParametersNames().length; ++i) {
            ExprNode parameter = this.chainParameters.get(i);
            if (parameter instanceof ExprWildcard && validationContext.getStreamTypeService().getEventTypes().length != 1) {
                throw new ExprValidationException("Expression '" + prototype.getName() + "' only allows a wildcard parameter if there is a single stream available, please use a stream or tag name instead");
            }
            if (this.isEventProviding(parameter, validationContext)) {
                eventParameters.add(i);
                continue;
            }
            valueParameters.add(i);
        }
        ObjectArrayEventType valueEventType = null;
        ArrayList<ExprNode> valueExpressions = new ArrayList<ExprNode>(valueParameters.size());
        if (!valueParameters.isEmpty()) {
            LinkedHashMap<String, Object> valuePropertyTypes = new LinkedHashMap<String, Object>();
            Iterator iterator = valueParameters.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                String name = prototype.getParametersNames()[index];
                ExprNode expr = this.chainParameters.get(index);
                Class result = JavaClassHelper.getBoxedType(expr.getForge().getEvaluationType());
                valuePropertyTypes.put(name, result);
                valueExpressions.add(expr);
            }
            valueEventType = ExprDotNodeUtility.makeTransientOAType(this.prototypeWVisibility.getName(), valuePropertyTypes, validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
        }
        int numEventTypes = eventParameters.size() + (valueEventType == null ? 0 : 1);
        EventType[] eventTypes = new EventType[numEventTypes];
        String[] streamNames = new String[numEventTypes];
        boolean[] isIStreamOnly = new boolean[numEventTypes];
        ExprEnumerationForge[] eventEnumerationForges = new ExprEnumerationForge[numEventTypes];
        this.allStreamIdsMatch = true;
        int offsetEventType = 0;
        if (valueEventType != null) {
            offsetEventType = 1;
            eventTypes[0] = valueEventType;
            streamNames[0] = INTERNAL_VALUE_STREAMNAME;
            isIStreamOnly[0] = true;
            this.allStreamIdsMatch = false;
        }
        boolean forceOptionalStream = false;
        Iterator iterator = eventParameters.iterator();
        while (iterator.hasNext()) {
            boolean istreamOnlyFlag;
            int streamId;
            ExprEnumerationForge forge;
            int index = (Integer)iterator.next();
            ExprNode parameter = this.chainParameters.get(index);
            streamNames[offsetEventType] = prototype.getParametersNames()[index];
            if (parameter instanceof ExprEnumerationForgeProvider) {
                ExprEnumerationForgeProvider enumerationForgeProvider = (ExprEnumerationForgeProvider)((Object)parameter);
                ExprEnumerationForgeDesc desc = enumerationForgeProvider.getEnumerationForge(validationContext.getStreamTypeService(), validationContext.getContextDescriptor());
                forge = desc.getForge();
                streamId = desc.getDirectIndexStreamNumber();
                istreamOnlyFlag = desc.isIstreamOnly();
            } else {
                forge = (ExprEnumerationForge)((Object)parameter.getForge());
                istreamOnlyFlag = false;
                streamId = -1;
                forceOptionalStream = true;
            }
            isIStreamOnly[offsetEventType] = istreamOnlyFlag;
            eventEnumerationForges[offsetEventType] = forge;
            eventTypes[offsetEventType] = forge.getEventTypeSingle(validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            if (streamId != index) {
                this.allStreamIdsMatch = false;
            }
            ++offsetEventType;
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        boolean optionalStream = forceOptionalStream || streamTypeService.isOptionalStreams();
        StreamTypeServiceImpl copyTypes = new StreamTypeServiceImpl(eventTypes, streamNames, isIStreamOnly, streamTypeService.isOnDemandStreams(), optionalStream);
        copyTypes.setRequireStreamNames(true);
        try {
            ExprValidationContext expressionBodyContext = new ExprValidationContext(copyTypes, validationContext);
            this.expressionBodyCopy = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRBODY, this.expressionBodyCopy, expressionBodyContext);
        }
        catch (ExprValidationException ex) {
            String message = "Failed to validate expression declaration '" + prototype.getName() + "': " + ex.getMessage();
            throw new ExprValidationException(message, ex);
        }
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expressionBodyCopy.accept(summaryVisitor);
        boolean isCache = !summaryVisitor.isHasAggregation() && !summaryVisitor.isHasPreviousPrior();
        boolean audit = AuditEnum.EXPRDEF.getAudit(validationContext.getAnnotations()) != null;
        String statementName = validationContext.getStatementName();
        this.forge = this.expressionBodyCopy.getForge().getForgeConstantType().isConstant() ? new ExprDeclaredForgeConstant(this, this.expressionBodyCopy.getForge().getEvaluationType(), prototype, this.expressionBodyCopy.getForge().getExprEvaluator().evaluate(null, true, null), audit, statementName) : (valueEventType == null && prototype.getParametersNames().length == 0 || this.allStreamIdsMatch ? new ExprDeclaredForgeNoRewrite(this, this.expressionBodyCopy.getForge(), isCache, audit, statementName) : (valueEventType == null ? new ExprDeclaredForgeRewrite(this, this.expressionBodyCopy.getForge(), isCache &= validationContext.getStatementCompileTimeService().getConfiguration().getCompiler().getExecution().isEnabledDeclaredExprValueCache(), eventEnumerationForges, audit, statementName) : new ExprDeclaredForgeRewriteWValue(this, this.expressionBodyCopy.getForge(), false, audit, statementName, eventEnumerationForges, valueEventType, valueExpressions)));
        return null;
    }

    private boolean isEventProviding(ExprNode parameter, ExprValidationContext validationContext) throws ExprValidationException {
        if (parameter instanceof ExprEnumerationForgeProvider) {
            ExprEnumerationForgeProvider provider = (ExprEnumerationForgeProvider)((Object)parameter);
            ExprEnumerationForgeDesc desc = provider.getEnumerationForge(validationContext.getStreamTypeService(), validationContext.getContextDescriptor());
            if (desc == null) {
                return false;
            }
            EventType eventType = desc.getForge().getEventTypeSingle(validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            return eventType != null;
        }
        ExprForge forge = parameter.getForge();
        if (forge instanceof ExprEnumerationForge) {
            ExprEnumerationForge enumerationForge = (ExprEnumerationForge)((Object)forge);
            return enumerationForge.getEventTypeSingle(validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService()) != null;
        }
        return false;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return this.forge instanceof ExprDeclaredForgeBase;
    }

    @Override
    public ExprFilterSpecLookupableForge getFilterLookupable() {
        if (!(this.forge instanceof ExprDeclaredForgeBase)) {
            return null;
        }
        ExprDeclaredForgeBase declaredForge = (ExprDeclaredForgeBase)this.forge;
        ExprForge forge = declaredForge.getInnerForge();
        DataInputOutputSerdeForge serde = this.exprValidationContext.getSerdeResolver().serdeForFilter(forge.getEvaluationType(), this.exprValidationContext.getStatementRawInfo());
        return new ExprFilterSpecLookupableForge(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this), new DeclaredNodeEventPropertyGetterForge(forge), null, forge.getEvaluationType(), true, serde);
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprDeclaredNodeImpl)) {
            return false;
        }
        ExprDeclaredNodeImpl otherExprCaseNode = (ExprDeclaredNodeImpl)node;
        return ExprNodeUtilityCompare.deepEquals(this.expressionBodyCopy, otherExprCaseNode, false);
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        this.acceptNoVisitParams(visitor);
        if (this.walkParams(visitor)) {
            ExprNodeUtilityQuery.acceptParams(visitor, this.chainParameters);
        }
    }

    @Override
    public void acceptNoVisitParams(ExprNodeVisitor visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        this.acceptNoVisitParams(visitor);
        if (this.walkParams(visitor)) {
            ExprNodeUtilityQuery.acceptParams(visitor, this.chainParameters);
        }
    }

    @Override
    public void acceptNoVisitParams(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        if (visitor.isVisit(this) && this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    public ExprNode getExpressionBodyCopy() {
        return this.expressionBodyCopy;
    }

    @Override
    public ExpressionDeclItem getPrototype() {
        return this.prototypeWVisibility;
    }

    public ExpressionDeclItem getPrototypeWVisibility() {
        return this.prototypeWVisibility;
    }

    @Override
    public List<ExprNode> getChainParameters() {
        return this.chainParameters;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    private void checkParameterCount() throws ExprValidationException {
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        if (this.chainParameters.size() != prototype.getParametersNames().length) {
            throw new ExprValidationException("Parameter count mismatches for declared expression '" + prototype.getName() + "', expected " + prototype.getParametersNames().length + " parameters but received " + this.chainParameters.size() + " parameters");
        }
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        writer.append(prototype.getName());
        if (prototype.isAlias()) {
            return;
        }
        writer.append("(");
        String delimiter = "";
        for (ExprNode parameter : this.chainParameters) {
            writer.append(delimiter);
            parameter.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    private boolean walkParams(ExprNodeVisitor visitor) {
        return visitor.isWalkDeclExprParam() || !this.allStreamIdsMatch;
    }

    private boolean walkParams(ExprNodeVisitorWithParent visitor) {
        return visitor.isWalkDeclExprParam() || !this.allStreamIdsMatch;
    }

    private static final class DeclaredNodeEventPropertyGetterForge
    implements ExprEventEvaluatorForge {
        private final ExprForge exprForge;

        public DeclaredNodeEventPropertyGetterForge(ExprForge exprForge) {
            this.exprForge = exprForge;
        }

        @Override
        public CodegenExpression eventBeanWithCtxGet(CodegenExpression beanExpression, CodegenExpression ctxExpression, CodegenMethodScope parent, CodegenClassScope classScope) {
            CodegenMethod method = parent.makeChild(this.exprForge.getEvaluationType(), this.getClass(), (CodegenScope)classScope).addParam(EventBean.class, "bean");
            CodegenMethod exprMethod = CodegenLegoMethodExpression.codegenExpression(this.exprForge, method, classScope);
            method.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.newArrayByLength(EventBean.class, CodegenExpressionBuilder.constant(1))).assignArrayElement(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("bean")).methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull()));
            return CodegenExpressionBuilder.localMethod(method, beanExpression);
        }
    }
}

