/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForgeGetArray;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import java.lang.reflect.Array;

public class ExprDotForgeGetArrayEval
implements ExprDotEval {
    private final ExprDotForgeGetArray forge;
    private final ExprEvaluator indexExpression;

    public ExprDotForgeGetArrayEval(ExprDotForgeGetArray forge, ExprEvaluator indexExpression) {
        this.forge = forge;
        this.indexExpression = indexExpression;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object index = this.indexExpression.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (index == null) {
            return null;
        }
        if (!(index instanceof Integer)) {
            return null;
        }
        int indexNum = (Integer)index;
        if (Array.getLength(target) <= indexNum) {
            return null;
        }
        return Array.get(target, indexNum);
    }

    public EPType getTypeInfo() {
        return this.forge.getTypeInfo();
    }

    @Override
    public ExprDotForge getDotForge() {
        return this.forge;
    }

    public static CodegenExpression codegen(ExprDotForgeGetArray forge, CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypeHelper.getNormalizedClass(forge.getTypeInfo()), ExprDotForgeGetArrayEval.class, (CodegenScope)codegenClassScope).addParam(innerType, "target");
        CodegenBlock block = methodNode.getBlock();
        if (!innerType.isPrimitive()) {
            block.ifRefNullReturnNull("target");
        }
        Class targetType = EPTypeHelper.getCodegenReturnType(forge.getTypeInfo());
        block.declareVar(Integer.TYPE, "index", forge.getIndexExpression().evaluateCodegen(Integer.TYPE, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("target")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("index"))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenLegoCast.castSafeFromObjectType(targetType, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.ref("index"))));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }
}

