/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.walk;

public class DotEscaper {
    public static String escapeDot(String identifierToEscape) {
        int indexof = identifierToEscape.indexOf(".");
        if (indexof == -1) {
            return identifierToEscape;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < identifierToEscape.length(); ++i) {
            char c = identifierToEscape.charAt(i);
            if (c != '.') {
                builder.append(c);
                continue;
            }
            if (i > 0 && identifierToEscape.charAt(i - 1) == '\\') {
                builder.append('.');
                continue;
            }
            builder.append('\\');
            builder.append('.');
        }
        return builder.toString();
    }

    public static String unescapeDot(String identifierToUnescape) {
        int indexof = identifierToUnescape.indexOf(".");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        indexof = identifierToUnescape.indexOf("\\");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        StringBuilder builder = new StringBuilder();
        int index = -1;
        int max = identifierToUnescape.length() - 1;
        do {
            char c;
            if ((c = identifierToUnescape.charAt(++index)) != '\\') {
                builder.append(c);
                continue;
            }
            if (index >= identifierToUnescape.length() - 1 || identifierToUnescape.charAt(index + 1) != '.') continue;
            builder.append('.');
            ++index;
        } while (index < max);
        return builder.toString();
    }
}

