/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprTypableReturnForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCaseNodeForge;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExprCaseNode
extends ExprNodeBase {
    private final boolean isCase2;
    private transient ExprCaseNodeForge forge;

    public ExprCaseNode(boolean isCase2) {
        this.isCase2 = isCase2;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprCaseNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprCaseNode.checkValidated(this.forge);
        return this.forge;
    }

    public boolean isCase2() {
        return this.isCase2;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        analysis = this.analyzeCase();
        for (UniformPair<ExprNode> pair : analysis.getWhenThenNodeList()) {
            if (this.isCase2 || (returnType = pair.getFirst().getForge().getEvaluationType()) == Boolean.TYPE || returnType == Boolean.class) continue;
            throw new ExprValidationException("Case node 'when' expressions must return a boolean value");
        }
        mustCoerce = false;
        coercer = null;
        if (this.isCase2) {
            comparedTypes = new LinkedList<Class>();
            comparedTypes.add(analysis.getOptionalCompareExprNode().getForge().getEvaluationType());
            for (Iterator<E> pair : analysis.getWhenThenNodeList()) {
                comparedTypes.add(((ExprNode)pair.getFirst()).getForge().getEvaluationType());
            }
            try {
                coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
                if (JavaClassHelper.isNumeric(coercionType)) {
                    mustCoerce = false;
                    for (Class comparedType : comparedTypes) {
                        if (comparedType == coercionType) continue;
                        mustCoerce = true;
                    }
                    if (mustCoerce) {
                        coercer = SimpleNumberCoercerFactory.getCoercer(null, coercionType);
                    }
                }
            }
            catch (CoercionException ex) {
                throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
            }
        }
        childTypes = new LinkedList<Class>();
        childMapTypes = new LinkedList<Object>();
        for (UniformPair<ExprNode> pair : analysis.getWhenThenNodeList()) {
            if (pair.getSecond().getForge() instanceof ExprTypableReturnForge && (rowProps = (typableReturn = (ExprTypableReturnForge)pair.getSecond().getForge()).getRowProperties()) != null) {
                childMapTypes.add(rowProps);
                continue;
            }
            childTypes.add(pair.getSecond().getForge().getEvaluationType());
        }
        if (analysis.getOptionalElseExprNode() != null) {
            if (analysis.getOptionalElseExprNode().getForge() instanceof ExprTypableReturnForge) {
                typableReturn = (ExprTypableReturnForge)analysis.getOptionalElseExprNode().getForge();
                rowProps = typableReturn.getRowProperties();
                if (rowProps != null) {
                    childMapTypes.add(rowProps);
                } else {
                    childTypes.add(analysis.getOptionalElseExprNode().getForge().getEvaluationType());
                }
            } else {
                childTypes.add(analysis.getOptionalElseExprNode().getForge().getEvaluationType());
            }
        }
        if (!childMapTypes.isEmpty() && !childTypes.isEmpty()) {
            message = "Case node 'when' expressions require that all results either return a single value or a Map-type (new-operator) value";
            count = -1;
            for (UniformPair pair : analysis.getWhenThenNodeList()) {
                ++count;
                if (((ExprNode)pair.getSecond()).getForge().getEvaluationType() == Map.class || ((ExprNode)pair.getSecond()).getForge().getEvaluationType() == null) continue;
                check = ", check when-condition number " + count;
                throw new ExprValidationException(message + check);
            }
            if (analysis.getOptionalElseExprNode() != null && analysis.getOptionalElseExprNode().getForge().getEvaluationType() != Map.class && analysis.getOptionalElseExprNode().getForge().getEvaluationType() != null) {
                check = ", check the else-condition";
                throw new ExprValidationException(message + check);
            }
            throw new ExprValidationException(message);
        }
        mapResultType = null;
        resultType = null;
        isNumericResult = false;
        if (childMapTypes.isEmpty()) {
            try {
                resultType = JavaClassHelper.getCommonCoercionType(childTypes.toArray(new Class[childTypes.size()]));
                if (!JavaClassHelper.isNumeric(resultType)) ** GOTO lbl81
                isNumericResult = true;
            }
            catch (CoercionException ex) {
                throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
            }
        } else {
            resultType = Map.class;
            mapResultType = (LinkedHashMap)childMapTypes.get(0);
            for (i = 1; i < childMapTypes.size(); ++i) {
                other = (Map)childMapTypes.get(i);
                messageEquals = MapEventType.isDeepEqualsProperties("Case-when number " + i, mapResultType, other);
                if (messageEquals == null) continue;
                throw new ExprValidationException("Incompatible case-when return types by new-operator in case-when number " + i + ": " + messageEquals.getMessage(), messageEquals);
            }
        }
lbl81:
        // 3 sources

        this.forge = new ExprCaseNodeForge(this, resultType, mapResultType, isNumericResult, mustCoerce, coercer, CaseAnalysis.access$000(analysis), CaseAnalysis.access$100(analysis), CaseAnalysis.access$200(analysis));
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprCaseNode)) {
            return false;
        }
        ExprCaseNode otherExprCaseNode = (ExprCaseNode)node;
        return this.isCase2 == otherExprCaseNode.isCase2;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        CaseAnalysis analysis;
        try {
            analysis = this.analyzeCase();
        }
        catch (ExprValidationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        writer.append("case");
        if (this.isCase2) {
            writer.append(' ');
            analysis.getOptionalCompareExprNode().toEPL(writer, this.getPrecedence(), flags);
        }
        for (UniformPair<ExprNode> p : analysis.getWhenThenNodeList()) {
            writer.append(" when ");
            p.getFirst().toEPL(writer, this.getPrecedence(), flags);
            writer.append(" then ");
            p.getSecond().toEPL(writer, this.getPrecedence(), flags);
        }
        if (analysis.getOptionalElseExprNode() != null) {
            writer.append(" else ");
            analysis.getOptionalElseExprNode().toEPL(writer, this.getPrecedence(), flags);
        }
        writer.append(" end");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.CASE;
    }

    private CaseAnalysis analyzeCaseOne() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes();
        if (children.length < 2) {
            throw new ExprValidationException("Case node must have at least 2 parameters");
        }
        LinkedList<UniformPair<ExprNode>> whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = children.length >> 1;
        for (int i = 0; i < numWhenThen; ++i) {
            ExprNode whenExpr = children[i << 1];
            ExprNode thenExpr = children[(i << 1) + 1];
            whenThenNodeList.add(new UniformPair<ExprNode>(whenExpr, thenExpr));
        }
        ExprNode optionalElseExprNode = null;
        if (children.length % 2 != 0) {
            optionalElseExprNode = children[children.length - 1];
        }
        return new CaseAnalysis(whenThenNodeList, null, optionalElseExprNode);
    }

    private CaseAnalysis analyzeCaseTwo() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes();
        if (children.length < 3) {
            throw new ExprValidationException("Case node must have at least 3 parameters");
        }
        ExprNode optionalCompareExprNode = children[0];
        LinkedList<UniformPair<ExprNode>> whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = (children.length - 1) / 2;
        for (int i = 0; i < numWhenThen; ++i) {
            whenThenNodeList.add(new UniformPair<ExprNode>(children[i * 2 + 1], children[i * 2 + 2]));
        }
        ExprNode optionalElseExprNode = null;
        if (numWhenThen * 2 + 1 < children.length) {
            optionalElseExprNode = children[children.length - 1];
        }
        return new CaseAnalysis(whenThenNodeList, optionalCompareExprNode, optionalElseExprNode);
    }

    private CaseAnalysis analyzeCase() throws ExprValidationException {
        if (this.isCase2) {
            return this.analyzeCaseTwo();
        }
        return this.analyzeCaseOne();
    }

    public static class CaseAnalysis {
        private List<UniformPair<ExprNode>> whenThenNodeList;
        private ExprNode optionalCompareExprNode;
        private ExprNode optionalElseExprNode;

        public CaseAnalysis(List<UniformPair<ExprNode>> whenThenNodeList, ExprNode optionalCompareExprNode, ExprNode optionalElseExprNode) {
            this.whenThenNodeList = whenThenNodeList;
            this.optionalCompareExprNode = optionalCompareExprNode;
            this.optionalElseExprNode = optionalElseExprNode;
        }

        public List<UniformPair<ExprNode>> getWhenThenNodeList() {
            return this.whenThenNodeList;
        }

        public ExprNode getOptionalCompareExprNode() {
            return this.optionalCompareExprNode;
        }

        public ExprNode getOptionalElseExprNode() {
            return this.optionalElseExprNode;
        }

        static /* synthetic */ List access$000(CaseAnalysis x0) {
            return x0.whenThenNodeList;
        }

        static /* synthetic */ ExprNode access$100(CaseAnalysis x0) {
            return x0.optionalCompareExprNode;
        }

        static /* synthetic */ ExprNode access$200(CaseAnalysis x0) {
            return x0.optionalElseExprNode;
        }
    }
}

