/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprInstanceofNodeForge;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ExprInstanceofNode
extends ExprNodeBase {
    private final String[] classIdentifiers;
    private transient ExprInstanceofNodeForge forge;

    public ExprInstanceofNode(String[] classIdentifiers) {
        this.classIdentifiers = classIdentifiers;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprInstanceofNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprInstanceofNode.checkValidated(this.forge);
        return this.forge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class[] classes;
        if (this.getChildNodes().length != 1) {
            throw new ExprValidationException("Instanceof node must have 1 child expression node supplying the expression to test");
        }
        if (this.classIdentifiers == null || this.classIdentifiers.length == 0) {
            throw new ExprValidationException("Instanceof node must have 1 or more class identifiers to verify type against");
        }
        Set<Class> classList = this.getClassSet(this.classIdentifiers, validationContext.getClasspathImportService());
        ExprInstanceofNode exprInstanceofNode = this;
        synchronized (exprInstanceofNode) {
            classes = classList.toArray(new Class[classList.size()]);
        }
        this.forge = new ExprInstanceofNodeForge(this, classes);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("instanceof(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(",");
        String delimiter = "";
        for (int i = 0; i < this.classIdentifiers.length; ++i) {
            writer.append(delimiter);
            writer.append(this.classIdentifiers[i]);
            delimiter = ",";
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprInstanceofNode)) {
            return false;
        }
        ExprInstanceofNode other = (ExprInstanceofNode)node;
        return Arrays.equals(other.classIdentifiers, this.classIdentifiers);
    }

    public String[] getClassIdentifiers() {
        return this.classIdentifiers;
    }

    private Set<Class> getClassSet(String[] classIdentifiers, ClasspathImportServiceCompileTime classpathImportService) throws ExprValidationException {
        HashSet<Class> classList = new HashSet<Class>();
        for (String className : classIdentifiers) {
            Class clazz = JavaClassHelper.getPrimitiveClassForName(className.trim());
            if (clazz != null) {
                classList.add(clazz);
                classList.add(JavaClassHelper.getBoxedType(clazz));
                continue;
            }
            try {
                clazz = JavaClassHelper.getClassForName(className.trim(), classpathImportService.getClassForNameProvider());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in instanceof function by name '" + className + "' cannot be loaded", e);
            }
            classList.add(JavaClassHelper.getPrimitiveType(clazz));
            classList.add(JavaClassHelper.getBoxedType(clazz));
        }
        return classList;
    }
}

