/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.MinMaxTypeEnum;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprMinMaxRowNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprMinMaxRowNode
extends ExprNodeBase {
    private final MinMaxTypeEnum minMaxTypeEnum;
    private transient ExprMinMaxRowNodeForge forge;

    public ExprMinMaxRowNode(MinMaxTypeEnum minMaxTypeEnum) {
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprMinMaxRowNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprMinMaxRowNode.checkValidated(this.forge);
        return this.forge;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("MinMax node must have at least 2 parameters");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getForge().getEvaluationType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.getChildNodes()[0].getForge().getEvaluationType();
        Class childTypeTwo = this.getChildNodes()[1].getForge().getEvaluationType();
        Class resultType = JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        for (int i = 2; i < this.getChildNodes().length; ++i) {
            resultType = JavaClassHelper.getArithmaticCoercionType(resultType, this.getChildNodes()[i].getForge().getEvaluationType());
        }
        this.forge = new ExprMinMaxRowNodeForge(this, resultType);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.minMaxTypeEnum.getExpressionText());
        writer.append('(');
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        for (int i = 2; i < this.getChildNodes().length; ++i) {
            writer.append(',');
            this.getChildNodes()[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprMinMaxRowNode)) {
            return false;
        }
        ExprMinMaxRowNode other = (ExprMinMaxRowNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }
}

