/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluatorForgeFromProp;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNodeForge;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNodeForgeFragmentType;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNodeForgeInnerEval;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNodeForgeStreamEvent;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.io.StringWriter;

public class ExprTypeofNode
extends ExprNodeBase
implements ExprFilterOptimizableNode {
    private transient ExprTypeofNodeForge forge;
    private transient ExprValidationContext exprValidationContext;

    public ExprEvaluator getExprEvaluator() {
        ExprTypeofNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.exprValidationContext = validationContext;
        if (this.getChildNodes().length != 1) {
            throw new ExprValidationException("Typeof node must have 1 child expression node supplying the expression to test");
        }
        if (this.getChildNodes()[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode stream = (ExprStreamUnderlyingNode)this.getChildNodes()[0];
            this.forge = new ExprTypeofNodeForgeStreamEvent(this, stream.getStreamId());
            return null;
        }
        if (this.getChildNodes()[0] instanceof ExprIdentNode) {
            ExprIdentNode ident = (ExprIdentNode)this.getChildNodes()[0];
            int streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(ident.getFullUnresolvedName());
            if (streamNum != -1) {
                this.forge = new ExprTypeofNodeForgeStreamEvent(this, streamNum);
                return null;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[ident.getStreamId()];
            FragmentEventType fragmentEventType = eventType.getFragmentType(ident.getResolvedPropertyName());
            if (fragmentEventType != null) {
                EventPropertyGetterSPI getter = ((EventTypeSPI)eventType).getGetterSPI(ident.getResolvedPropertyName());
                this.forge = new ExprTypeofNodeForgeFragmentType(this, ident.getStreamId(), getter, fragmentEventType.getFragmentType().getName());
                return null;
            }
        }
        this.forge = new ExprTypeofNodeForgeInnerEval(this);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return String.class;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return true;
    }

    @Override
    public ExprFilterSpecLookupableForge getFilterLookupable() {
        EventPropertyValueGetterForge eventPropertyForge = new EventPropertyValueGetterForge(){

            @Override
            public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope parent, CodegenClassScope classScope) {
                CodegenMethod method = parent.makeChild(String.class, this.getClass(), (CodegenScope)classScope).addParam(EventBean.class, "bean");
                method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("bean")).add("getEventType", new CodegenExpression[0]).add("getName", new CodegenExpression[0]));
                return CodegenExpressionBuilder.localMethod(method, beanExpression);
            }
        };
        DataInputOutputSerdeForge serde = this.exprValidationContext.getSerdeResolver().serdeForFilter(String.class, this.exprValidationContext.getStatementRawInfo());
        ExprEventEvaluatorForgeFromProp eval = new ExprEventEvaluatorForgeFromProp(eventPropertyForge);
        return new ExprFilterSpecLookupableForge(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this), eval, null, String.class, true, serde);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("typeof(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprTypeofNode;
    }
}

