/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNodeForge;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.LinkedList;

public class ExprArrayNode
extends ExprNodeBase {
    private transient ExprArrayNodeForge forge;
    private Class optionalRequiredType;

    public ExprEvaluator getExprEvaluator() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    public boolean isConstantResult() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getConstantResult() != null;
    }

    @Override
    public ExprForge getForge() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge;
    }

    public Class getComponentTypeCollection() throws ExprValidationException {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getArrayReturnType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        void var9_19;
        int length = this.getChildNodes().length;
        if (this.getChildNodes().length == 0) {
            this.forge = this.optionalRequiredType == null ? new ExprArrayNodeForge(this, Object.class, CollectionUtil.OBJECTARRAY_EMPTY) : new ExprArrayNodeForge(this, this.optionalRequiredType, Array.newInstance(this.optionalRequiredType, 0));
            return null;
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < length; ++i) {
            comparedTypes.add(this.getChildNodes()[i].getForge().getEvaluationType());
        }
        Class arrayReturnType = null;
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        try {
            if (this.optionalRequiredType == null) {
                arrayReturnType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
                if (JavaClassHelper.isNumeric(arrayReturnType)) {
                    mustCoerce = false;
                    for (Class clazz : comparedTypes) {
                        if (clazz == arrayReturnType) continue;
                        mustCoerce = true;
                    }
                    if (mustCoerce) {
                        coercer = SimpleNumberCoercerFactory.getCoercer(null, arrayReturnType);
                    }
                }
            } else {
                arrayReturnType = this.optionalRequiredType;
                Class arrayBoxedType = JavaClassHelper.getBoxedType(arrayReturnType);
                for (Class clazz : comparedTypes) {
                    if (JavaClassHelper.isAssignmentCompatible(JavaClassHelper.getBoxedType(clazz), arrayBoxedType)) continue;
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + JavaClassHelper.getClassNameFullyQualPretty(arrayReturnType) + " but received type " + JavaClassHelper.getClassNameFullyQualPretty(clazz));
                }
            }
        }
        catch (CoercionException arrayBoxedType) {
            // empty catch block
        }
        if (arrayReturnType == null) {
            arrayReturnType = Object.class;
        }
        Object[] results = new Object[length];
        boolean bl = false;
        for (ExprNode child : this.getChildNodes()) {
            void var8_14;
            if (!child.getForge().getForgeConstantType().isCompileTimeConstant()) {
                results = null;
                break;
            }
            results[var8_14] = this.getChildNodes()[var8_14].getForge().getExprEvaluator().evaluate(null, false, null);
            ++var8_14;
        }
        Object var9_17 = null;
        if (results != null) {
            Object object = Array.newInstance(arrayReturnType, length);
            for (int i = 0; i < length; ++i) {
                if (mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = coercer.coerceBoxed(boxed);
                    Array.set(object, i, coercedResult);
                    continue;
                }
                if (arrayReturnType.isPrimitive() && results[i] == null) {
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + JavaClassHelper.getClassNameFullyQualPretty(arrayReturnType) + " but received null");
                }
                try {
                    Array.set(object, i, results[i]);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + JavaClassHelper.getClassNameFullyQualPretty(arrayReturnType) + " but received type " + JavaClassHelper.getClassNameFullyQualPretty(results[i].getClass()));
                }
            }
        }
        this.forge = new ExprArrayNodeForge(this, arrayReturnType, mustCoerce, coercer, var9_19);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String delimiter = "";
        writer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
            delimiter = ",";
        }
        writer.append('}');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprArrayNode;
    }

    public void setOptionalRequiredType(Class optionalRequiredType) {
        this.optionalRequiredType = optionalRequiredType;
    }

    public Class getOptionalRequiredType() {
        return this.optionalRequiredType;
    }
}

