/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNodeForgeEval;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

public class ExprArrayNodeForge
implements ExprForgeInstrumentable,
ExprEnumerationForge {
    private final ExprArrayNode parent;
    private final Class arrayReturnType;
    private final boolean mustCoerce;
    private final SimpleNumberCoercer coercer;
    private final Object constantResult;

    public ExprArrayNodeForge(ExprArrayNode parent, Class arrayReturnType, Object constantResult) {
        this.parent = parent;
        this.arrayReturnType = arrayReturnType;
        this.constantResult = constantResult;
        this.mustCoerce = false;
        this.coercer = null;
    }

    public ExprArrayNodeForge(ExprArrayNode parent, Class arrayReturnType, boolean mustCoerce, SimpleNumberCoercer coercer, Object constantResult) {
        this.parent = parent;
        this.arrayReturnType = arrayReturnType;
        this.mustCoerce = mustCoerce;
        this.coercer = coercer;
        this.constantResult = constantResult;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        if (this.constantResult != null) {
            return ExprForgeConstantType.COMPILETIMECONST;
        }
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        if (this.constantResult != null) {
            return new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return ExprArrayNodeForge.this.constantResult;
                }
            };
        }
        return new ExprArrayNodeForgeEval(this, ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parent.getChildNodes()));
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.constantResult != null) {
            return CodegenExpressionBuilder.constant(this.constantResult);
        }
        return ExprArrayNodeForgeEval.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprArray", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprArrayNodeForgeEval.codegenEvaluateGetROCollectionScalar(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Class getEvaluationType() {
        return Array.newInstance(this.arrayReturnType, 0).getClass();
    }

    @Override
    public ExprArrayNode getForgeRenderable() {
        return this.parent;
    }

    public Class getArrayReturnType() {
        return this.arrayReturnType;
    }

    public boolean isMustCoerce() {
        return this.mustCoerce;
    }

    public SimpleNumberCoercer getCoercer() {
        return this.coercer;
    }

    public Object getConstantResult() {
        return this.constantResult;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        if (this.constantResult != null) {
            final ArrayList<Object> constantResultList = new ArrayList<Object>();
            for (int i = 0; i < this.parent.getChildNodes().length; ++i) {
                constantResultList.add(Array.get(this.constantResult, i));
            }
            return new ExprEnumerationEval(){

                @Override
                public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return null;
                }

                @Override
                public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return constantResultList;
                }

                @Override
                public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return null;
                }
            };
        }
        return new ExprArrayNodeForgeEval(this, ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parent.getChildNodes()));
    }

    public ExprArrayNode getParent() {
        return this.parent;
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.parent.getComponentTypeCollection();
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return null;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

