/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBetweenNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;

public class ExprBetweenNodeImpl
extends ExprNodeBase
implements ExprBetweenNode {
    private final boolean isLowEndpointIncluded;
    private final boolean isHighEndpointIncluded;
    private final boolean isNotBetween;
    private transient ExprBetweenNodeForge forge;

    public ExprBetweenNodeImpl(boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprBetweenNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprBetweenNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean isLowEndpointIncluded() {
        return this.isLowEndpointIncluded;
    }

    @Override
    public boolean isHighEndpointIncluded() {
        return this.isHighEndpointIncluded;
    }

    @Override
    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 3) {
            throw new ExprValidationException("The Between operator requires exactly 3 child expressions");
        }
        ExprForge[] forges = ExprNodeUtilityQuery.getForges(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(forges[0].getEvaluationType());
        Class typeTwo = JavaClassHelper.getBoxedType(forges[1].getEvaluationType());
        Class typeThree = JavaClassHelper.getBoxedType(forges[2].getEvaluationType());
        if (typeOne == null) {
            throw new ExprValidationException("Null value not allowed in between-clause");
        }
        boolean isAlwaysFalse = false;
        ExprBetweenComp computer = null;
        if (typeTwo == null || typeThree == null) {
            isAlwaysFalse = true;
        } else {
            if (typeOne != String.class || typeTwo != String.class || typeThree != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeThree)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeThree.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class intermedType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            Class compareType = JavaClassHelper.getCompareToCoercionType(intermedType, typeThree);
            computer = this.makeComputer(compareType, typeOne, typeTwo, typeThree);
        }
        this.forge = new ExprBetweenNodeForge(this, computer, isAlwaysFalse);
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprBetweenNodeImpl)) {
            return false;
        }
        ExprBetweenNodeImpl other = (ExprBetweenNodeImpl)node;
        return other.isNotBetween == this.isNotBetween;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        if (this.isLowEndpointIncluded && this.isHighEndpointIncluded) {
            it.next().toEPL(writer, this.getPrecedence(), flags);
            if (this.isNotBetween) {
                writer.append(" not between ");
            } else {
                writer.append(" between ");
            }
            it.next().toEPL(writer, this.getPrecedence(), flags);
            writer.append(" and ");
            it.next().toEPL(writer, this.getPrecedence(), flags);
        } else {
            it.next().toEPL(writer, this.getPrecedence(), flags);
            writer.write(" in ");
            if (this.isLowEndpointIncluded) {
                writer.write(91);
            } else {
                writer.write(40);
            }
            it.next().toEPL(writer, this.getPrecedence(), flags);
            writer.write(58);
            it.next().toEPL(writer, this.getPrecedence(), flags);
            if (this.isHighEndpointIncluded) {
                writer.write(93);
            } else {
                writer.write(41);
            }
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    private ExprBetweenComp makeComputer(Class compareType, Class valueType, Class lowType, Class highType) {
        ExprBetweenComp computer = compareType == String.class ? new ExprBetweenCompString(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : (compareType == BigDecimal.class ? new ExprBetweenCompBigDecimal(this.isLowEndpointIncluded, this.isHighEndpointIncluded, valueType, lowType, highType) : (compareType == BigInteger.class ? new ExprBetweenCompBigInteger(this.isLowEndpointIncluded, this.isHighEndpointIncluded, valueType, lowType, highType) : (compareType == Long.class ? new ExprBetweenCompLong(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : new ExprBetweenCompDouble(this.isLowEndpointIncluded, this.isHighEndpointIncluded))));
        return computer;
    }

    protected static class ExprBetweenCompBigInteger
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;
        private SimpleNumberBigIntegerCoercer numberCoercerLower;
        private SimpleNumberBigIntegerCoercer numberCoercerUpper;
        private SimpleNumberBigIntegerCoercer numberCoercerValue;

        public ExprBetweenCompBigInteger(boolean lowIncluded, boolean highIncluded, Class valueType, Class lowerType, Class upperType) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
            this.numberCoercerLower = SimpleNumberCoercerFactory.getCoercerBigInteger(lowerType);
            this.numberCoercerUpper = SimpleNumberCoercerFactory.getCoercerBigInteger(upperType);
            this.numberCoercerValue = SimpleNumberCoercerFactory.getCoercerBigInteger(valueType);
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            BigInteger upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            BigInteger valueD = this.numberCoercerValue.coerceBoxedBigInt((Number)value);
            BigInteger lowerD = this.numberCoercerLower.coerceBoxedBigInt((Number)lower);
            if (lowerD.compareTo(upperD = this.numberCoercerUpper.coerceBoxedBigInt((Number)upper)) > 0) {
                BigInteger temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD.compareTo(lowerD) > 0) {
                if (valueD.compareTo(upperD) < 0) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD.equals(upperD);
                }
                return false;
            }
            return this.isLowIncluded && valueD.equals(lowerD);
        }

        @Override
        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef value, Class valueType, CodegenExpressionRef lower, Class lowerType, CodegenExpressionRef higher, Class higherType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprBetweenCompBigInteger.class, (CodegenScope)codegenClassScope).addParam(BigInteger.class, "value").addParam(BigInteger.class, "lower").addParam(BigInteger.class, "upper").getBlock().ifRefNullReturnFalse("value").ifRefNullReturnFalse("lower").ifRefNullReturnFalse("upper").ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("lower"), "compareTo", CodegenExpressionBuilder.ref("upper")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0))).declareVar(BigInteger.class, "temp", (CodegenExpression)CodegenExpressionBuilder.ref("upper")).assignRef("upper", (CodegenExpression)CodegenExpressionBuilder.ref("lower")).assignRef("lower", (CodegenExpression)CodegenExpressionBuilder.ref("temp")).blockEnd();
            CodegenBlock ifValueGTLower = block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("lower")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0)));
            ifValueGTLower.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("upper")), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantTrue());
            if (this.isHighIncluded) {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("upper")));
            } else {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            CodegenMethod method = this.isLowIncluded ? block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("lower"))) : block.methodReturn(CodegenExpressionBuilder.constantFalse());
            CodegenExpression valueCoerced = this.numberCoercerValue.coerceBoxedBigIntCodegen(value, valueType);
            CodegenExpression lowerCoerced = this.numberCoercerValue.coerceBoxedBigIntCodegen(lower, lowerType);
            CodegenExpression higherCoerced = this.numberCoercerValue.coerceBoxedBigIntCodegen(higher, higherType);
            return CodegenExpressionBuilder.localMethod(method, valueCoerced, lowerCoerced, higherCoerced);
        }
    }

    protected static class ExprBetweenCompBigDecimal
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;
        private SimpleNumberBigDecimalCoercer numberCoercerLower;
        private SimpleNumberBigDecimalCoercer numberCoercerUpper;
        private SimpleNumberBigDecimalCoercer numberCoercerValue;

        public ExprBetweenCompBigDecimal(boolean lowIncluded, boolean highIncluded, Class valueType, Class lowerType, Class upperType) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
            this.numberCoercerLower = SimpleNumberCoercerFactory.getCoercerBigDecimal(lowerType);
            this.numberCoercerUpper = SimpleNumberCoercerFactory.getCoercerBigDecimal(upperType);
            this.numberCoercerValue = SimpleNumberCoercerFactory.getCoercerBigDecimal(valueType);
        }

        @Override
        public boolean isBetween(Object valueUncast, Object lowerUncast, Object upperUncast) {
            int valueComparedLower;
            BigDecimal upper;
            if (valueUncast == null || lowerUncast == null || upperUncast == null) {
                return false;
            }
            BigDecimal value = this.numberCoercerValue.coerceBoxedBigDec((Number)valueUncast);
            BigDecimal lower = this.numberCoercerLower.coerceBoxedBigDec((Number)lowerUncast);
            if (lower.compareTo(upper = this.numberCoercerUpper.coerceBoxedBigDec((Number)upperUncast)) > 0) {
                BigDecimal temp = upper;
                upper = lower;
                lower = temp;
            }
            if ((valueComparedLower = value.compareTo(lower)) > 0) {
                int valueComparedUpper = value.compareTo(upper);
                if (valueComparedUpper < 0) {
                    return true;
                }
                return this.isHighIncluded && valueComparedUpper == 0;
            }
            return this.isLowIncluded && valueComparedLower == 0;
        }

        @Override
        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef value, Class valueType, CodegenExpressionRef lower, Class lowerType, CodegenExpressionRef higher, Class higherType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprBetweenCompBigDecimal.class, (CodegenScope)codegenClassScope).addParam(BigDecimal.class, "value").addParam(BigDecimal.class, "lower").addParam(BigDecimal.class, "upper").getBlock().ifRefNullReturnFalse("value").ifRefNullReturnFalse("lower").ifRefNullReturnFalse("upper").ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("lower"), "compareTo", CodegenExpressionBuilder.ref("upper")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0))).declareVar(BigDecimal.class, "temp", (CodegenExpression)CodegenExpressionBuilder.ref("upper")).assignRef("upper", (CodegenExpression)CodegenExpressionBuilder.ref("lower")).assignRef("lower", (CodegenExpression)CodegenExpressionBuilder.ref("temp")).blockEnd();
            CodegenBlock ifValueGTLower = block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("lower")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0)));
            ifValueGTLower.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("upper")), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantTrue());
            if (this.isHighIncluded) {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("upper")));
            } else {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            CodegenMethod method = this.isLowIncluded ? block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("lower"))) : block.methodReturn(CodegenExpressionBuilder.constantFalse());
            CodegenExpression valueCoerced = this.numberCoercerValue.coerceBoxedBigDecCodegen(value, valueType);
            CodegenExpression lowerCoerced = this.numberCoercerValue.coerceBoxedBigDecCodegen(lower, lowerType);
            CodegenExpression higherCoerced = this.numberCoercerValue.coerceBoxedBigDecCodegen(higher, higherType);
            return CodegenExpressionBuilder.localMethod(method, valueCoerced, lowerCoerced, higherCoerced);
        }
    }

    protected static class ExprBetweenCompLong
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompLong(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            long upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            long valueD = ((Number)value).longValue();
            long lowerD = ((Number)lower).longValue();
            if (lowerD > (upperD = ((Number)upper).longValue())) {
                long temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }

        @Override
        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef value, Class valueType, CodegenExpressionRef lower, Class lowerType, CodegenExpressionRef higher, Class higherType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprBetweenCompLong.class, (CodegenScope)codegenClassScope).addParam(Long.TYPE, "value").addParam(Long.TYPE, "lower").addParam(Long.TYPE, "upper").getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("lower"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("upper"))).declareVar(Long.TYPE, "temp", (CodegenExpression)CodegenExpressionBuilder.ref("upper")).assignRef("upper", (CodegenExpression)CodegenExpressionBuilder.ref("lower")).assignRef("lower", (CodegenExpression)CodegenExpressionBuilder.ref("temp")).blockEnd();
            CodegenBlock ifValueGTLower = block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("value"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("lower")));
            ifValueGTLower.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("value"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.ref("upper"))).blockReturn(CodegenExpressionBuilder.constantTrue());
            if (this.isHighIncluded) {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("upper")));
            } else {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            CodegenMethod method = this.isLowIncluded ? block.methodReturn(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("lower"))) : block.methodReturn(CodegenExpressionBuilder.constantFalse());
            return CodegenExpressionBuilder.localMethod(method, value, lower, higher);
        }
    }

    protected static class ExprBetweenCompDouble
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompDouble(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            double upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            double valueD = ((Number)value).doubleValue();
            double lowerD = ((Number)lower).doubleValue();
            if (lowerD > (upperD = ((Number)upper).doubleValue())) {
                double temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }

        @Override
        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef value, Class valueType, CodegenExpressionRef lower, Class lowerType, CodegenExpressionRef higher, Class higherType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprBetweenCompDouble.class, (CodegenScope)codegenClassScope).addParam(Double.TYPE, "value").addParam(Double.TYPE, "lower").addParam(Double.TYPE, "upper").getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("lower"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("upper"))).declareVar(Double.TYPE, "temp", (CodegenExpression)CodegenExpressionBuilder.ref("upper")).assignRef("upper", (CodegenExpression)CodegenExpressionBuilder.ref("lower")).assignRef("lower", (CodegenExpression)CodegenExpressionBuilder.ref("temp")).blockEnd();
            CodegenBlock ifValueGTLower = block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("value"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("lower")));
            ifValueGTLower.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("value"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.ref("upper"))).blockReturn(CodegenExpressionBuilder.constantTrue());
            if (this.isHighIncluded) {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("upper")));
            } else {
                ifValueGTLower.blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            CodegenMethod method = this.isLowIncluded ? block.methodReturn(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("lower"))) : block.methodReturn(CodegenExpressionBuilder.constantFalse());
            return CodegenExpressionBuilder.localMethod(method, value, lower, higher);
        }
    }

    protected static class ExprBetweenCompString
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompString(boolean lowIncluded, boolean isHighIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = isHighIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            if (value == null || lower == null || upper == null) {
                return false;
            }
            String valueStr = (String)value;
            String upperStr = (String)upper;
            String lowerStr = (String)lower;
            if (upperStr.compareTo(lowerStr) < 0) {
                String temp = upperStr;
                upperStr = lowerStr;
                lowerStr = temp;
            }
            if (valueStr.compareTo(lowerStr) < 0) {
                return false;
            }
            if (valueStr.compareTo(upperStr) > 0) {
                return false;
            }
            if (!this.isLowIncluded && valueStr.equals(lowerStr)) {
                return false;
            }
            return this.isHighIncluded || !valueStr.equals(upperStr);
        }

        public boolean isEqualsEndpoint(Object value, Object endpoint) {
            return value.equals(endpoint);
        }

        @Override
        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef value, Class valueType, CodegenExpressionRef lower, Class lowerType, CodegenExpressionRef higher, Class higherType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprBetweenCompString.class, (CodegenScope)codegenClassScope).addParam(String.class, "value").addParam(String.class, "lower").addParam(String.class, "upper").getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("upper"), "compareTo", CodegenExpressionBuilder.ref("lower")), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).declareVar(String.class, "temp", (CodegenExpression)CodegenExpressionBuilder.ref("upper")).assignRef("upper", (CodegenExpression)CodegenExpressionBuilder.ref("lower")).assignRef("lower", (CodegenExpression)CodegenExpressionBuilder.ref("temp")).blockEnd().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("lower")), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantFalse()).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "compareTo", CodegenExpressionBuilder.ref("upper")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantFalse());
            if (!this.isLowIncluded) {
                block.ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("lower"))).blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            if (!this.isHighIncluded) {
                block.ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "equals", CodegenExpressionBuilder.ref("upper"))).blockReturn(CodegenExpressionBuilder.constantFalse());
            }
            CodegenMethod method = block.methodReturn(CodegenExpressionBuilder.constantTrue());
            return CodegenExpressionBuilder.localMethod(method, value, lower, higher);
        }
    }

    protected static interface ExprBetweenComp {
        public boolean isBetween(Object var1, Object var2, Object var3);

        public CodegenExpression codegenNoNullCheck(CodegenExpressionRef var1, Class var2, CodegenExpressionRef var3, Class var4, CodegenExpressionRef var5, Class var6, CodegenMethodScope var7, CodegenClassScope var8);
    }
}

