/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBitWiseNodeForge;
import com.espertech.esper.common.internal.type.BitWiseOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprBitWiseNode
extends ExprNodeBase {
    private final BitWiseOpEnum bitWiseOpEnum;
    private transient ExprBitWiseNodeForge forge;

    public ExprBitWiseNode(BitWiseOpEnum bitWiseOpEnum) {
        this.bitWiseOpEnum = bitWiseOpEnum;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprBitWiseNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprBitWiseNode.checkValidated(this.forge);
        return this.forge;
    }

    public BitWiseOpEnum getBitWiseOpEnum() {
        return this.bitWiseOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("BitWise node must have 2 parameters");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes()[1].getForge().getEvaluationType());
        this.checkNumericOrBoolean(typeOne);
        this.checkNumericOrBoolean(typeTwo);
        if (JavaClassHelper.isFloatingPointClass(typeOne) || JavaClassHelper.isFloatingPointClass(typeTwo)) {
            throw new ExprValidationException("Invalid type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        if (typeOne != typeTwo) {
            throw new ExprValidationException("Bitwise expressions must be of the same type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        BitWiseOpEnum.Computer computer = this.bitWiseOpEnum.getComputer(typeOne);
        this.forge = new ExprBitWiseNodeForge(this, typeOne, computer);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprBitWiseNode)) {
            return false;
        }
        ExprBitWiseNode other = (ExprBitWiseNode)node;
        return other.bitWiseOpEnum == this.bitWiseOpEnum;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        writer.append(this.bitWiseOpEnum.getComputeDescription());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.BITWISE;
    }

    private void checkNumericOrBoolean(Class childType) throws ExprValidationException {
        if (!JavaClassHelper.isBoolean(childType) && !JavaClassHelper.isNumeric(childType)) {
            throw new ExprValidationException("Invalid datatype for binary operator, " + childType.getName() + " is not allowed");
        }
    }
}

