/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForge;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExprEqualsAllAnyNode
extends ExprNodeBase {
    private final boolean isNot;
    private final boolean isAll;
    private transient ExprEqualsAllAnyNodeForge forge;

    public ExprEqualsAllAnyNode(boolean isNotEquals, boolean isAll) {
        this.isNot = isNotEquals;
        this.isAll = isAll;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprEqualsAllAnyNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprEqualsAllAnyNode.checkValidated(this.forge);
        return this.forge;
    }

    public boolean isNot() {
        return this.isNot;
    }

    public boolean isAll() {
        return this.isAll;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionTypeBoxed;
        if (this.getChildNodes().length < 1) {
            throw new IllegalStateException("Equals group node does not have 1 or more parameters");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        boolean hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.getChildNodes()[i + 1].getForge().getEvaluationType();
            if (propType == null) continue;
            if (propType.isArray()) {
                hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionTypeBoxed = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        if (JavaClassHelper.isNumeric(coercionTypeBoxed)) {
            for (Class compareType : comparedTypes) {
                if (coercionTypeBoxed == JavaClassHelper.getBoxedType(compareType)) continue;
                mustCoerce = true;
            }
            if (mustCoerce) {
                coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionTypeBoxed));
            }
        }
        this.forge = new ExprEqualsAllAnyNodeForge(this, mustCoerce, coercer, coercionTypeBoxed, hasCollectionOrArray);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        if (this.isAll) {
            if (this.isNot) {
                writer.append("!=all");
            } else {
                writer.append("=all");
            }
        } else if (this.isNot) {
            writer.append("!=any");
        } else {
            writer.append("=any");
        }
        writer.append("(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            writer.append(delimiter);
            this.getChildNodes()[i + 1].toEPL(writer, this.getPrecedence(), flags);
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.EQUALS;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprEqualsAllAnyNode)) {
            return false;
        }
        ExprEqualsAllAnyNode other = (ExprEqualsAllAnyNode)node;
        return other.isNot == this.isNot && other.isAll == this.isAll;
    }
}

