/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForgeEvalAllNoColl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForgeEvalAllWColl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForgeEvalAnyNoColl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForgeEvalAnyWColl;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;

public class ExprEqualsAllAnyNodeForge
implements ExprForgeInstrumentable {
    private final ExprEqualsAllAnyNode parent;
    private final boolean mustCoerce;
    private final SimpleNumberCoercer coercer;
    private final Class coercionTypeBoxed;
    private final boolean hasCollectionOrArray;

    public ExprEqualsAllAnyNodeForge(ExprEqualsAllAnyNode parent, boolean mustCoerce, SimpleNumberCoercer coercer, Class coercionTypeBoxed, boolean hasCollectionOrArray) {
        this.parent = parent;
        this.mustCoerce = mustCoerce;
        this.coercer = coercer;
        this.coercionTypeBoxed = coercionTypeBoxed;
        this.hasCollectionOrArray = hasCollectionOrArray;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parent.getChildNodes());
        if (this.parent.isAll()) {
            if (!this.hasCollectionOrArray) {
                return new ExprEqualsAllAnyNodeForgeEvalAllNoColl(this, evaluators);
            }
            return new ExprEqualsAllAnyNodeForgeEvalAllWColl(this, evaluators);
        }
        if (!this.hasCollectionOrArray) {
            return new ExprEqualsAllAnyNodeForgeEvalAnyNoColl(this, evaluators);
        }
        return new ExprEqualsAllAnyNodeForgeEvalAnyWColl(this, evaluators);
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprEqualsAnyOrAll", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.parent.isAll()) {
            return ExprEqualsAllAnyNodeForgeEvalAllWColl.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
        }
        return ExprEqualsAllAnyNodeForgeEvalAnyWColl.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Class getEvaluationType() {
        return Boolean.class;
    }

    @Override
    public ExprEqualsAllAnyNode getForgeRenderable() {
        return this.parent;
    }

    public boolean isMustCoerce() {
        return this.mustCoerce;
    }

    public SimpleNumberCoercer getCoercer() {
        return this.coercer;
    }

    public Class getCoercionTypeBoxed() {
        return this.coercionTypeBoxed;
    }
}

