/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCompareEquals;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ExprInNodeForgeEvalWColl
implements ExprEvaluator {
    private final ExprInNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprInNodeForgeEvalWColl(ExprInNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object inPropResult = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        boolean isNotIn = this.forge.getForgeRenderable().isNotIn();
        int len = this.evaluators.length - 1;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Number left;
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) continue;
            if (rightResult instanceof Collection) {
                if (inPropResult == null) {
                    return null;
                }
                Collection coll = (Collection)rightResult;
                if (!coll.contains(inPropResult)) continue;
                return !isNotIn;
            }
            if (rightResult instanceof Map) {
                if (inPropResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (!coll.containsKey(inPropResult)) continue;
                return !isNotIn;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                if (arrayLength > 0 && inPropResult == null) {
                    return null;
                }
                for (int index = 0; index < arrayLength; ++index) {
                    Number right2;
                    Number left2;
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    if (!(!this.forge.isMustCoerce() ? inPropResult.equals(item) : item instanceof Number && (left2 = this.forge.getCoercer().coerceBoxed((Number)inPropResult)).equals(right2 = this.forge.getCoercer().coerceBoxed((Number)item)))) continue;
                    return !isNotIn;
                }
                continue;
            }
            if (inPropResult == null) {
                return null;
            }
            if (!(!this.forge.isMustCoerce() ? inPropResult.equals(rightResult) : (left = this.forge.getCoercer().coerceBoxed((Number)inPropResult)).equals(right = this.forge.getCoercer().coerceBoxed((Number)rightResult)))) continue;
            return !isNotIn;
        }
        if (hasNullRow) {
            return null;
        }
        return isNotIn;
    }

    public static CodegenExpression codegen(ExprInNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge[] forges = ExprNodeUtilityQuery.getForges(forge.getForgeRenderable().getChildNodes());
        boolean isNot = forge.getForgeRenderable().isNotIn();
        CodegenMethod methodNode = codegenMethodScope.makeChild(Boolean.class, ExprInNodeForgeEvalWColl.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(Boolean.TYPE, "hasNullRow", CodegenExpressionBuilder.constantFalse());
        Class leftTypeUncoerced = forges[0].getEvaluationType();
        Class leftTypeCoerced = forge.getCoercionType();
        block.declareVar(leftTypeUncoerced, "left", forges[0].evaluateCodegen(leftTypeUncoerced, methodNode, exprSymbol, codegenClassScope));
        block.declareVar(forge.getCoercionType(), "leftCoerced", !forge.isMustCoerce() ? CodegenExpressionBuilder.ref("left") : forge.getCoercer().coerceCodegenMayNullBoxed(CodegenExpressionBuilder.ref("left"), leftTypeUncoerced, methodNode, codegenClassScope));
        for (int i = 1; i < forges.length; ++i) {
            CodegenBlock ifRightNotNull;
            Class reftype = forges[i].getEvaluationType();
            ExprForge refforge = forges[i];
            String refname = "r" + i;
            if (reftype == null) {
                block.assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue());
                continue;
            }
            block.declareVar(reftype, refname, refforge.evaluateCodegen(reftype, methodNode, exprSymbol, codegenClassScope));
            if (JavaClassHelper.isImplementsInterface(reftype, Collection.class)) {
                ifRightNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                if (!leftTypeUncoerced.isPrimitive()) {
                    ifRightNotNull.ifRefNullReturnNull("left");
                }
                ifRightNotNull.ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refname), "contains", CodegenExpressionBuilder.ref("left"))).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(reftype, Map.class)) {
                ifRightNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                if (!leftTypeUncoerced.isPrimitive()) {
                    ifRightNotNull.ifRefNullReturnNull("left");
                }
                ifRightNotNull.ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refname), "containsKey", CodegenExpressionBuilder.ref("left"))).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
                continue;
            }
            if (reftype.isArray()) {
                ifRightNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                if (!leftTypeUncoerced.isPrimitive()) {
                    ifRightNotNull.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref(refname)), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("left")), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull());
                }
                CodegenBlock forLoop = ifRightNotNull.forLoopIntSimple("index", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref(refname)));
                forLoop.declareVar(reftype.getComponentType(), "item", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref(refname), CodegenExpressionBuilder.ref("index")));
                forLoop.declareVar(Boolean.TYPE, "itemNull", reftype.getComponentType().isPrimitive() ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("item")));
                CodegenBlock itemNotNull = forLoop.ifCondition(CodegenExpressionBuilder.ref("itemNull")).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue()).ifElse();
                if (!forge.isMustCoerce()) {
                    itemNotNull.ifCondition(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftCoerced"), leftTypeCoerced, CodegenExpressionBuilder.ref("item"), reftype.getComponentType())).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
                    continue;
                }
                if (!JavaClassHelper.isNumeric(reftype.getComponentType())) continue;
                itemNotNull.ifCondition(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftCoerced"), leftTypeCoerced, forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref("item"), reftype.getComponentType()), forge.getCoercionType())).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
                continue;
            }
            CodegenBlock codegenBlock = ifRightNotNull = reftype.isPrimitive() ? block : block.ifRefNotNull(refname);
            if (!leftTypeUncoerced.isPrimitive()) {
                ifRightNotNull.ifRefNullReturnNull("left");
            }
            if (!forge.isMustCoerce()) {
                ifRightNotNull.ifCondition(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftCoerced"), leftTypeCoerced, CodegenExpressionBuilder.ref(refname), reftype)).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
            } else {
                ifRightNotNull.ifCondition(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftCoerced"), leftTypeCoerced, forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), reftype), forge.getCoercionType())).blockReturn(!isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
            }
            if (reftype.isPrimitive()) continue;
            block.ifRefNull(refname).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue());
        }
        block.ifCondition(CodegenExpressionBuilder.ref("hasNullRow")).blockReturn(CodegenExpressionBuilder.constantNull());
        block.methodReturn(isNot ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.constantFalse());
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

