/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForgeConstEval;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForgeNonconst;
import com.espertech.esper.common.internal.util.LikeUtil;

public class ExprLikeNodeFormNonconstEval
implements ExprEvaluator {
    private final ExprLikeNodeForgeNonconst form;
    private final ExprEvaluator lhsEval;
    private final ExprEvaluator patternEval;
    private final ExprEvaluator optionalEscapeEval;

    ExprLikeNodeFormNonconstEval(ExprLikeNodeForgeNonconst forge, ExprEvaluator lhsEval, ExprEvaluator patternEval, ExprEvaluator optionalEscapeEval) {
        this.form = forge;
        this.lhsEval = lhsEval;
        this.patternEval = patternEval;
        this.optionalEscapeEval = optionalEscapeEval;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        String escapeString;
        String pattern = (String)this.patternEval.evaluate(eventsPerStream, isNewData, context);
        if (pattern == null) {
            return null;
        }
        Character es = Character.valueOf('\\');
        if (this.optionalEscapeEval != null && (escapeString = (String)this.optionalEscapeEval.evaluate(eventsPerStream, isNewData, context)) != null && !escapeString.isEmpty()) {
            es = Character.valueOf(escapeString.charAt(0));
        }
        LikeUtil likeUtil = new LikeUtil(pattern, es, false);
        Object value = this.lhsEval.evaluate(eventsPerStream, isNewData, context);
        if (value == null) {
            return null;
        }
        if (this.form.isNumericValue()) {
            value = value.toString();
        }
        boolean result = this.form.getForgeRenderable().isNot() ^ likeUtil.compare((String)value);
        return result;
    }

    public static CodegenMethod codegen(ExprLikeNodeForgeNonconst forge, ExprNode lhs, ExprNode pattern, ExprNode optionalEscape, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(Boolean.class, ExprLikeNodeFormNonconstEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock blockMethod = methodNode.getBlock().declareVar(String.class, "pattern", pattern.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("pattern");
        blockMethod.declareVar(Character.class, "es", CodegenExpressionBuilder.constant(Character.valueOf('\\')));
        if (optionalEscape != null) {
            blockMethod.declareVar(String.class, "escapeString", optionalEscape.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope));
            blockMethod.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("escapeString")), CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("escapeString"), "isEmpty", new CodegenExpression[0])), new CodegenExpression[0])).assignRef("es", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("escapeString"), "charAt", CodegenExpressionBuilder.constant(0)));
        }
        blockMethod.declareVar(LikeUtil.class, "likeUtil", CodegenExpressionBuilder.newInstance(LikeUtil.class, CodegenExpressionBuilder.ref("pattern"), CodegenExpressionBuilder.ref("es"), CodegenExpressionBuilder.constant(false)));
        if (!forge.isNumericValue()) {
            blockMethod.declareVar(String.class, "value", lhs.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprLikeNodeForgeConstEval.getLikeCode(forge, CodegenExpressionBuilder.ref("likeUtil"), CodegenExpressionBuilder.ref("value")));
        } else {
            blockMethod.declareVar(Object.class, "value", lhs.getForge().evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprLikeNodeForgeConstEval.getLikeCode(forge, CodegenExpressionBuilder.ref("likeUtil"), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "toString", new CodegenExpression[0])));
        }
        return methodNode;
    }
}

