/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeArrayForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeNonArrayForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactory;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactoryFactory;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprNewInstanceNode
extends ExprNodeBase {
    private final String classIdent;
    private final int numArrayDimensions;
    private boolean arrayInitializedByExpr;
    private transient ExprForge forge;

    public ExprNewInstanceNode(String classIdent, int numArrayDimensions) {
        this.classIdent = classIdent;
        this.numArrayDimensions = numArrayDimensions;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class targetClass = null;
        if (this.numArrayDimensions != 0) {
            targetClass = JavaClassHelper.getPrimitiveClassForName(this.classIdent);
        }
        if (targetClass == null) {
            try {
                targetClass = validationContext.getClasspathImportService().resolveClass(this.classIdent, false, validationContext.getClassProvidedClasspathExtension());
            }
            catch (ClasspathImportException e) {
                throw new ExprValidationException("Failed to resolve new-operator class name '" + this.classIdent + "'");
            }
        }
        if (this.numArrayDimensions == 0) {
            InstanceManufacturerFactory manufacturerFactory = InstanceManufacturerFactoryFactory.getManufacturer(targetClass, validationContext.getClasspathImportService(), this.getChildNodes());
            this.forge = new ExprNewInstanceNodeNonArrayForge(this, targetClass, manufacturerFactory);
            return null;
        }
        Class targetClassArray = JavaClassHelper.getArrayType(targetClass, this.numArrayDimensions);
        if (this.getChildNodes().length == 1 && this.getChildNodes()[0] instanceof ExprArrayNode) {
            this.arrayInitializedByExpr = true;
        } else {
            for (ExprNode child : this.getChildNodes()) {
                Class evalType = child.getForge().getEvaluationType();
                if (JavaClassHelper.getBoxedType(evalType) == Integer.class) continue;
                String message = "New-keyword with an array-type result requires an Integer-typed dimension but received type '" + JavaClassHelper.getClassNameFullyQualPretty(evalType) + "'";
                throw new ExprValidationException(message);
            }
        }
        if (!this.arrayInitializedByExpr) {
            this.forge = new ExprNewInstanceNodeArrayForge(this, targetClass, targetClassArray);
            return null;
        }
        if (this.numArrayDimensions < 1 || this.numArrayDimensions > 2) {
            throw new IllegalStateException("Num-array-dimensions unexpected at " + this.numArrayDimensions);
        }
        ExprArrayNode arrayNode = (ExprArrayNode)this.getChildNodes()[0];
        if (this.numArrayDimensions == 2) {
            for (ExprNode inner : arrayNode.getChildNodes()) {
                if (!(inner instanceof ExprArrayNode)) {
                    throw new ExprValidationException("Two-dimensional array element does not allow element expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(inner) + "'");
                }
                ExprArrayNode innerArray = (ExprArrayNode)inner;
                innerArray.setOptionalRequiredType(targetClass);
                innerArray.validate(validationContext);
            }
            arrayNode.setOptionalRequiredType(targetClassArray.getComponentType());
        } else {
            arrayNode.setOptionalRequiredType(targetClass);
        }
        arrayNode.validate(validationContext);
        this.forge = new ExprNewInstanceNodeArrayForge(this, targetClass, targetClassArray);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public String getClassIdent() {
        return this.classIdent;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprNewInstanceNode)) {
            return false;
        }
        ExprNewInstanceNode other = (ExprNewInstanceNode)node;
        return other.classIdent.equals(this.classIdent) && other.numArrayDimensions == this.numArrayDimensions;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.write("new ");
        writer.write(this.classIdent);
        if (this.numArrayDimensions == 0) {
            ExprNodeUtilityPrint.toExpressionStringParams(writer, this.getChildNodes());
        } else if (this.arrayInitializedByExpr) {
            writer.write("[] ");
            this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.UNARY, flags);
        } else {
            for (ExprNode child : this.getChildNodes()) {
                writer.write("[");
                child.toEPL(writer, ExprPrecedenceEnum.UNARY, flags);
                writer.write("]");
            }
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public int getNumArrayDimensions() {
        return this.numArrayDimensions;
    }

    public boolean isArrayInitializedByExpr() {
        return this.arrayInitializedByExpr;
    }
}

