/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeArrayForge;
import java.lang.reflect.Array;

public class ExprNewInstanceNodeArrayForgeEval
implements ExprEvaluator {
    private static final String NULL_MSG = "new-array received a null value for dimension";
    private final ExprNewInstanceNodeArrayForge forge;

    public ExprNewInstanceNodeArrayForgeEval(ExprNewInstanceNodeArrayForge forge) {
        this.forge = forge;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.forge.getParent().isArrayInitializedByExpr()) {
            return this.forge.getParent().getChildNodes()[0].getForge().getExprEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        ExprNode[] children = this.forge.getParent().getChildNodes();
        int[] dimensions = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            Integer size = (Integer)this.forge.getParent().getChildNodes()[i].getForge().getExprEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (size == null) {
                throw new EPException(NULL_MSG);
            }
            dimensions[i] = size;
        }
        return Array.newInstance(this.forge.getTargetClass(), dimensions);
    }

    public static CodegenExpression evaluateCodegen(Class requiredType, ExprNewInstanceNodeArrayForge forge, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression make;
        if (forge.getParent().isArrayInitializedByExpr()) {
            return forge.getParent().getChildNodes()[0].getForge().evaluateCodegen(requiredType, parent, symbols, classScope);
        }
        CodegenMethod method = parent.makeChild(requiredType, ExprNewInstanceNodeArrayForgeEval.class, (CodegenScope)classScope);
        ExprNode[] dimensions = forge.getParent().getChildNodes();
        CodegenExpression[] dimValue = new CodegenExpression[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            ExprForge dimForge = forge.getParent().getChildNodes()[i].getForge();
            CodegenExpression dimExpr = dimForge.evaluateCodegen(Integer.class, method, symbols, classScope);
            if (dimForge.getForgeConstantType() == ExprForgeConstantType.COMPILETIMECONST) {
                dimValue[i] = dimExpr;
                continue;
            }
            String name = "dim" + i;
            method.getBlock().declareVar(Integer.class, name, dimExpr).ifRefNull(name).blockThrow(CodegenExpressionBuilder.newInstance(EPException.class, CodegenExpressionBuilder.constant(NULL_MSG)));
            dimValue[i] = CodegenExpressionBuilder.ref(name);
        }
        if (dimValue.length == 1) {
            make = CodegenExpressionBuilder.newArrayByLength(forge.getTargetClass(), dimValue[0]);
        } else {
            CodegenExpression[] params = new CodegenExpression[dimValue.length + 1];
            params[0] = CodegenExpressionBuilder.clazz(forge.getTargetClass());
            System.arraycopy(dimValue, 0, params, 1, dimValue.length);
            make = CodegenExpressionBuilder.staticMethod(Array.class, "newInstance", params);
        }
        method.getBlock().methodReturn(CodegenLegoCast.castSafeFromObjectType(requiredType, make));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

