/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRegexpNodeForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRegexpNodeForgeConst;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRegexpNodeForgeNonconst;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExprRegexpNode
extends ExprNodeBase {
    private final boolean isNot;
    private transient ExprRegexpNodeForge forge;

    public ExprRegexpNode(boolean not) {
        this.isNot = not;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprRegexpNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprRegexpNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("The regexp operator requires 2 child expressions");
        }
        Class patternChildType = this.getChildNodes()[1].getForge().getEvaluationType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The regexp operator requires a String-type pattern expression");
        }
        boolean constantPattern = this.getChildNodes()[1].getForge().getForgeConstantType().isCompileTimeConstant();
        Class evalChildType = this.getChildNodes()[0].getForge().getEvaluationType();
        boolean isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !isNumericValue) {
            throw new ExprValidationException("The regexp operator requires a String or numeric type left-hand expression");
        }
        if (constantPattern) {
            Pattern pattern;
            String patternText = (String)this.getChildNodes()[1].getForge().getExprEvaluator().evaluate(null, true, null);
            try {
                pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new ExprValidationException("Failed to compile regex pattern '" + patternText + "': " + ex.getMessage(), ex);
            }
            CodegenExpression patternInit = CodegenExpressionBuilder.staticMethod(Pattern.class, "compile", CodegenExpressionBuilder.constant(patternText));
            this.forge = new ExprRegexpNodeForgeConst(this, isNumericValue, pattern, patternInit);
        } else {
            this.forge = new ExprRegexpNodeForgeNonconst(this, isNumericValue);
        }
        return null;
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRegexpNode)) {
            return false;
        }
        ExprRegexpNode other = (ExprRegexpNode)node;
        return this.isNot == other.isNot;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        if (this.isNot) {
            writer.append(" not");
        }
        writer.append(" regexp ");
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    public boolean isNot() {
        return this.isNot;
    }
}

