/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.prior;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.prior.PriorEvalStrategy;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprPriorNode
extends ExprNodeBase
implements ExprEvaluator,
ExprForgeInstrumentable {
    private Class resultType;
    private int streamNumber;
    private int constantIndexNumber;
    private ExprForge innerForge;
    private int relativeIndex = -1;
    private CodegenFieldName priorStrategyFieldName;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public int getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public ExprForge getInnerForge() {
        return this.innerForge;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.resultType;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Prior node must have 2 parameters");
        }
        if (!this.getChildNodes()[0].getForge().getForgeConstantType().isCompileTimeConstant()) {
            throw new ExprValidationException("Prior function requires a constant-value integer-typed index expression as the first parameter");
        }
        ExprNodeUtilityMake.setChildIdentNodesOptionalEvent(this);
        ExprNode constantNode = this.getChildNodes()[0];
        Class constantNodeType = constantNode.getForge().getEvaluationType();
        if (constantNodeType != Integer.class && constantNodeType != Integer.TYPE) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        Object value = constantNode.getForge().getExprEvaluator().evaluate(null, false, null);
        this.constantIndexNumber = ((Number)value).intValue();
        this.innerForge = this.getChildNodes()[1].getForge();
        if (this.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[1];
            this.streamNumber = identNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.innerForge.getEvaluationType());
        } else if (this.getChildNodes()[1] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes()[1];
            this.streamNumber = streamNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.innerForge.getEvaluationType());
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (validationContext.getViewResourceDelegate() == null) {
            throw new ExprValidationException("Prior function cannot be used in this context");
        }
        validationContext.getViewResourceDelegate().addPriorNodeRequest(this);
        this.priorStrategyFieldName = validationContext.getMemberNames().priorStrategy(this.streamNumber);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod method = parent.makeChild(this.resultType, this.getClass(), (CodegenScope)codegenClassScope);
        CodegenMethod innerEval = CodegenLegoMethodExpression.codegenExpression(this.innerForge, method, codegenClassScope);
        CodegenExpressionRef eps = exprSymbol.getAddEPS(method);
        CodegenExpressionField future = codegenClassScope.getPackageScope().addOrGetFieldWellKnown(this.priorStrategyFieldName, PriorEvalStrategy.class);
        method.getBlock().declareVar(EventBean.class, "originalEvent", CodegenExpressionBuilder.arrayAtIndex(eps, CodegenExpressionBuilder.constant(this.streamNumber))).declareVar(EventBean.class, "substituteEvent", CodegenExpressionBuilder.exprDotMethod(future, "getSubstituteEvent", CodegenExpressionBuilder.ref("originalEvent"), exprSymbol.getAddIsNewData(method), CodegenExpressionBuilder.constant(this.constantIndexNumber), CodegenExpressionBuilder.constant(this.relativeIndex), exprSymbol.getAddExprEvalCtx(method), CodegenExpressionBuilder.constant(this.streamNumber))).assignArrayElement(eps, CodegenExpressionBuilder.constant(this.streamNumber), (CodegenExpression)CodegenExpressionBuilder.ref("substituteEvent")).declareVar(this.resultType, "evalResult", (CodegenExpression)CodegenExpressionBuilder.localMethod(innerEval, eps, exprSymbol.getAddIsNewData(method), exprSymbol.getAddExprEvalCtx(method))).assignArrayElement(eps, CodegenExpressionBuilder.constant(this.streamNumber), (CodegenExpression)CodegenExpressionBuilder.ref("originalEvent")).methodReturn(CodegenExpressionBuilder.ref("evalResult"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprPrior", requiredType, parent, exprSymbol, codegenClassScope).build();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("prior(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprPriorNode;
    }

    public void setRelativeIndex(int relativeIndex) {
        this.relativeIndex = relativeIndex;
    }
}

