/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.table;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameTableAccess;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableNodeUtil;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactoryForge;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import java.io.StringWriter;
import java.util.Collection;

public abstract class ExprTableAccessNode
extends ExprNodeBase
implements ExprForgeInstrumentable,
ExprEvaluator {
    protected final String tableName;
    protected TableMetaData tableMeta;
    protected ExprTableEvalStrategyFactoryForge strategy;
    protected ExprForge[] groupKeyEvaluators;
    private int tableAccessNumber = -1;

    protected abstract void validateBindingInternal(ExprValidationContext var1) throws ExprValidationException;

    protected abstract boolean equalsNodeInternal(ExprTableAccessNode var1);

    protected abstract String getInstrumentationQName();

    protected abstract CodegenExpression[] getInstrumentationQParams();

    public abstract ExprTableEvalStrategyFactoryForge getTableAccessFactoryForge();

    public ExprTableAccessNode(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public final ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.tableMeta = validationContext.getTableCompileTimeResolver().resolve(this.tableName);
        if (this.tableMeta == null) {
            throw new ExprValidationException("Failed to resolve table name '" + this.tableName + "' to a table");
        }
        if (!validationContext.isAllowBindingConsumption()) {
            throw new ExprValidationException("Invalid use of table access expression, expression '" + this.getTableName() + "' is not allowed here");
        }
        if (this.tableMeta.getOptionalContextName() != null && validationContext.getContextDescriptor() != null && !this.tableMeta.getOptionalContextName().equals(validationContext.getContextDescriptor().getContextName())) {
            throw new ExprValidationException("Table by name '" + this.getTableName() + "' has been declared for context '" + this.tableMeta.getOptionalContextName() + "' and can only be used within the same context");
        }
        this.validateBindingInternal(validationContext);
        return null;
    }

    protected void validateGroupKeys(TableMetaData metadata, ExprValidationContext validationContext) throws ExprValidationException {
        this.groupKeyEvaluators = this.getChildNodes().length > 0 ? ExprNodeUtilityQuery.getForges(this.getChildNodes()) : new ExprForge[0];
        Class[] typesReturned = ExprNodeUtilityQuery.getExprResultTypes(this.getChildNodes());
        Class[] keyTypes = metadata.isKeyed() ? metadata.getKeyTypes() : new Class[]{};
        ExprTableNodeUtil.validateExpressions(this.getTableName(), typesReturned, "key", this.getChildNodes(), keyTypes, "key");
    }

    @Override
    public final ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprTableAccessNode.makeEvaluate(AccessEvaluationType.PLAIN, this, this.getEvaluationType(), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, this.getInstrumentationQName(), requiredType, parent, exprSymbol, codegenClassScope).qparams(this.getInstrumentationQParams()).build();
    }

    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprTableAccessNode.makeEvaluate(AccessEvaluationType.GETEVENTCOLL, this, Collection.class, parent, exprSymbol, codegenClassScope);
    }

    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprTableAccessNode.makeEvaluate(AccessEvaluationType.GETSCALARCOLL, this, Collection.class, parent, exprSymbol, codegenClassScope);
    }

    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprTableAccessNode.makeEvaluate(AccessEvaluationType.GETEVENT, this, EventBean.class, parent, exprSymbol, codegenClassScope);
    }

    @Override
    public final ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public final Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    protected void toPrecedenceFreeEPLInternal(StringWriter writer, String subprop, ExprNodeRenderableFlags flags) {
        this.toPrecedenceFreeEPLInternal(writer, flags);
        writer.append(".");
        writer.append(subprop);
    }

    protected void toPrecedenceFreeEPLInternal(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.getTableName());
        if (this.getChildNodes().length > 0) {
            writer.append("[");
            String delimiter = "";
            for (ExprNode expr : this.getChildNodes()) {
                writer.append(delimiter);
                expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
                delimiter = ",";
            }
            writer.append("]");
        }
    }

    protected TableMetadataColumn validateSubpropertyGetCol(TableMetaData tableMetadata, String subpropName) throws ExprValidationException {
        TableMetadataColumn column = tableMetadata.getColumns().get(subpropName);
        if (column == null) {
            throw new ExprValidationException("A column '" + subpropName + "' could not be found for table '" + this.getTableName() + "'");
        }
        return column;
    }

    @Override
    public boolean equalsNode(ExprNode o, boolean ignoreStreamPrefix) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprTableAccessNode that = (ExprTableAccessNode)o;
        if (!this.getTableName().equals(that.getTableName())) {
            return false;
        }
        return this.equalsNodeInternal(that);
    }

    public void setTableAccessNumber(int tableAccessNumber) {
        this.tableAccessNumber = tableAccessNumber;
    }

    public int getTableAccessNumber() {
        return this.tableAccessNumber;
    }

    public TableMetaData getTableMeta() {
        return this.tableMeta;
    }

    protected static CodegenExpression makeEvaluate(AccessEvaluationType evaluationType, ExprTableAccessNode accessNode, Class resultType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        if (accessNode.getTableAccessNumber() == -1) {
            throw new IllegalStateException("Table expression node has not been assigned");
        }
        CodegenMethod method = parent.makeChild(resultType, ExprTableAccessNode.class, (CodegenScope)classScope);
        CodegenExpressionRef eps = symbols.getAddEPS(method);
        CodegenExpression newData = symbols.getAddIsNewData(method);
        CodegenExpressionRef evalCtx = symbols.getAddExprEvalCtx(method);
        CodegenExpressionField future = classScope.getPackageScope().addOrGetFieldWellKnown(new CodegenFieldNameTableAccess(accessNode.tableAccessNumber), ExprTableEvalStrategy.class);
        CodegenExpression evaluation = CodegenExpressionBuilder.exprDotMethod(future, evaluationType.getMethodName(), eps, newData, evalCtx);
        if (resultType != Object.class) {
            evaluation = CodegenExpressionBuilder.cast(resultType, evaluation);
        }
        method.getBlock().methodReturn(evaluation);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    static enum AccessEvaluationType {
        PLAIN("evaluate"),
        GETEVENTCOLL("evaluateGetROCollectionEvents"),
        GETSCALARCOLL("evaluateGetROCollectionScalar"),
        GETEVENT("evaluateGetEventBean"),
        EVALTYPABLESINGLE("evaluateTypableSingle");

        private final String methodName;

        private AccessEvaluationType(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

