/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.table;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForgeForProps;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnPlain;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyEnum;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactoryForge;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import java.io.StringWriter;
import java.util.Collection;

public class ExprTableAccessNodeSubprop
extends ExprTableAccessNode
implements ExprEvaluator,
ExprEnumerationForge,
ExprEnumerationEval,
ExprForge {
    private final String subpropName;
    private Class bindingReturnType;
    private transient EPType optionalEnumerationType;
    private transient ExprEnumerationGivenEventForge optionalPropertyEnumEvaluator;

    public ExprTableAccessNodeSubprop(String tableName, String subpropName) {
        super(tableName);
        this.subpropName = subpropName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.bindingReturnType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public ExprTableEvalStrategyFactoryForge getTableAccessFactoryForge() {
        TableMetadataColumn column = this.tableMeta.getColumns().get(this.subpropName);
        boolean ungrouped = !this.tableMeta.isKeyed();
        ExprTableEvalStrategyFactoryForge forge = new ExprTableEvalStrategyFactoryForge(this.tableMeta, this.groupKeyEvaluators);
        if (column instanceof TableMetadataColumnPlain) {
            TableMetadataColumnPlain plain = (TableMetadataColumnPlain)column;
            forge.setPropertyIndex(plain.getIndexPlain());
            forge.setStrategyEnum(ungrouped ? ExprTableEvalStrategyEnum.UNGROUPED_PLAINCOL : ExprTableEvalStrategyEnum.GROUPED_PLAINCOL);
            forge.setOptionalEnumEval(this.optionalPropertyEnumEvaluator);
        } else {
            TableMetadataColumnAggregation aggcol = (TableMetadataColumnAggregation)column;
            forge.setAggColumnNum(aggcol.getColumn());
            forge.setStrategyEnum(ungrouped ? ExprTableEvalStrategyEnum.UNGROUPED_AGG_SIMPLE : ExprTableEvalStrategyEnum.GROUPED_AGG_SIMPLE);
        }
        return forge;
    }

    @Override
    protected String getInstrumentationQName() {
        return "ExprTableSubproperty";
    }

    @Override
    protected CodegenExpression[] getInstrumentationQParams() {
        return new CodegenExpression[]{CodegenExpressionBuilder.constant(this.tableMeta.getTableName()), CodegenExpressionBuilder.constant(this.subpropName)};
    }

    @Override
    protected void validateBindingInternal(ExprValidationContext validationContext) throws ExprValidationException {
        this.validateGroupKeys(this.tableMeta, validationContext);
        TableMetadataColumn column = this.validateSubpropertyGetCol(this.tableMeta, this.subpropName);
        this.bindingReturnType = this.tableMeta.getPublicEventType().getPropertyType(this.subpropName);
        if (column instanceof TableMetadataColumnPlain) {
            ExprDotEnumerationSourceForgeForProps enumerationSource = ExprDotNodeUtility.getPropertyEnumerationSource(this.subpropName, 0, this.tableMeta.getInternalEventType(), true, true);
            this.optionalEnumerationType = enumerationSource.getReturnType();
            this.optionalPropertyEnumEvaluator = enumerationSource.getEnumerationGivenEvent();
        } else {
            TableMetadataColumnAggregation aggcol = (TableMetadataColumnAggregation)column;
            this.optionalEnumerationType = aggcol.getOptionalEnumerationType();
        }
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.toPrecedenceFreeEPLInternal(writer, this.subpropName, flags);
    }

    public String getSubpropName() {
        return this.subpropName;
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return EPTypeHelper.optionalIsEventTypeColl(this.optionalEnumerationType);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return EPTypeHelper.optionalIsComponentTypeColl(this.optionalEnumerationType);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return EPTypeHelper.optionalIsEventTypeSingle(this.optionalEnumerationType);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    protected boolean equalsNodeInternal(ExprTableAccessNode other) {
        ExprTableAccessNodeSubprop that = (ExprTableAccessNodeSubprop)other;
        return this.subpropName.equals(that.subpropName);
    }
}

