/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.table;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprTableIdentNode
extends ExprNodeBase
implements ExprForgeInstrumentable {
    private final TableMetaData tableMetadata;
    private final String streamOrPropertyName;
    private final String unresolvedPropertyName;
    private final Class returnType;
    private final int streamNum;
    private final String columnName;
    private final int columnNum;

    public ExprTableIdentNode(TableMetaData tableMetadata, String streamOrPropertyName, String unresolvedPropertyName, Class returnType, int streamNum, String columnName, int columnNum) {
        this.tableMetadata = tableMetadata;
        this.streamOrPropertyName = streamOrPropertyName;
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.returnType = returnType;
        this.streamNum = streamNum;
        this.columnName = columnName;
        this.columnNum = columnNum;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        ExprIdentNodeImpl.toPrecedenceFreeEPL(writer, this.streamOrPropertyName, this.unresolvedPropertyName, ExprNodeRenderableFlags.DEFAULTFLAGS);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return false;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        return null;
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        CodegenMethod method = parent.makeChild(requiredType, this.getClass(), (CodegenScope)codegenClassScope);
        method.getBlock().declareVar(Object.class, "result", CodegenExpressionBuilder.staticMethod(ExprTableIdentNode.class, "tableColumnAggValue", CodegenExpressionBuilder.constant(this.streamNum), CodegenExpressionBuilder.constant(this.columnNum), symbols.getAddEPS(method), symbols.getAddIsNewData(method), symbols.getAddExprEvalCtx(method)));
        if (requiredType == Object.class) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.ref("result"));
        } else {
            method.getBlock().methodReturn(CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(requiredType), (CodegenExpression)CodegenExpressionBuilder.ref("result")));
        }
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprTableSubproperty", requiredType, parent, symbols, codegenClassScope).qparams(CodegenExpressionBuilder.constant(this.tableMetadata.getTableName()), CodegenExpressionBuilder.constant(this.unresolvedPropertyName)).build();
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                throw new UnsupportedOperationException("Cannot evaluate at compile time");
            }
        };
    }

    @Override
    public Class getEvaluationType() {
        return this.returnType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    public TableMetaData getTableMetadata() {
        return this.tableMetadata;
    }

    public int getStreamNum() {
        return this.streamNum;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public static AggregationRow tableColumnRow(int streamNum, EventBean[] eventsPerStream) {
        ObjectArrayBackedEventBean oa = (ObjectArrayBackedEventBean)eventsPerStream[streamNum];
        return ExprTableEvalStrategyUtil.getRow(oa);
    }

    public static Object tableColumnAggValue(int streamNum, int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext ctx) {
        ObjectArrayBackedEventBean oa = (ObjectArrayBackedEventBean)eventsPerStream[streamNum];
        AggregationRow row = ExprTableEvalStrategyUtil.getRow(oa);
        return row.getValue(column, eventsPerStream, isNewData, ctx);
    }
}

