/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.eval;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeConstGivenDeltaEval;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodUtil;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriodUtil;
import com.espertech.esper.common.internal.schedule.TimeProvider;

public class TimePeriodComputeNCGivenExprEval
implements TimePeriodCompute {
    private ExprEvaluator secondsEvaluator;
    private TimeAbacus timeAbacus;

    public TimePeriodComputeNCGivenExprEval() {
    }

    public TimePeriodComputeNCGivenExprEval(ExprEvaluator secondsEvaluator, TimeAbacus timeAbacus) {
        this.secondsEvaluator = secondsEvaluator;
        this.timeAbacus = timeAbacus;
    }

    public void setSecondsEvaluator(ExprEvaluator secondsEvaluator) {
        this.secondsEvaluator = secondsEvaluator;
    }

    public void setTimeAbacus(TimeAbacus timeAbacus) {
        this.timeAbacus = timeAbacus;
    }

    @Override
    public long deltaAdd(long fromTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.eval(eventsPerStream, isNewData, context);
    }

    @Override
    public long deltaSubtract(long fromTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.eval(eventsPerStream, isNewData, context);
    }

    @Override
    public TimePeriodDeltaResult deltaAddWReference(long fromTime, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long delta = this.eval(eventsPerStream, isNewData, context);
        return new TimePeriodDeltaResult(TimePeriodUtil.deltaAddWReference(fromTime, reference, delta), reference);
    }

    @Override
    public long deltaUseRuntimeTime(EventBean[] eventsPerStream, ExprEvaluatorContext context, TimeProvider timeProvider) {
        return this.eval(eventsPerStream, true, context);
    }

    @Override
    public TimePeriodProvide getNonVariableProvide(ExprEvaluatorContext context) {
        long msec = this.eval(null, true, context);
        return new TimePeriodComputeConstGivenDeltaEval(msec);
    }

    private long eval(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Number time = (Number)this.secondsEvaluator.evaluate(eventsPerStream, isNewData, context);
        if (!ExprTimePeriodUtil.validateTime(time, this.timeAbacus)) {
            throw new EPException(ExprTimePeriodUtil.getTimeInvalidMsg("Invalid time computation result", time == null ? "null" : time.toString(), time));
        }
        return this.timeAbacus.deltaForSecondsNumber(time);
    }
}

