/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdder;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeConstGivenCalAddEval;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.TimeProvider;
import java.util.Calendar;
import java.util.TimeZone;

public class TimePeriodComputeNCGivenTPCalForgeEval
implements TimePeriodCompute {
    private ExprEvaluator[] evaluators;
    private TimePeriodAdder[] adders;
    private TimeAbacus timeAbacus;
    private TimeZone timeZone;
    private int indexMicroseconds;

    public TimePeriodComputeNCGivenTPCalForgeEval() {
    }

    public TimePeriodComputeNCGivenTPCalForgeEval(ExprEvaluator[] evaluators, TimePeriodAdder[] adders, TimeAbacus timeAbacus, TimeZone timeZone, int indexMicroseconds) {
        this.evaluators = evaluators;
        this.adders = adders;
        this.timeAbacus = timeAbacus;
        this.timeZone = timeZone;
        this.indexMicroseconds = indexMicroseconds;
    }

    public void setEvaluators(ExprEvaluator[] evaluators) {
        this.evaluators = evaluators;
    }

    public void setAdders(TimePeriodAdder[] adders) {
        this.adders = adders;
    }

    public void setTimeAbacus(TimeAbacus timeAbacus) {
        this.timeAbacus = timeAbacus;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setIndexMicroseconds(int indexMicroseconds) {
        this.indexMicroseconds = indexMicroseconds;
    }

    @Override
    public long deltaAdd(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, 1, eventsPerStream, isNewData, context);
    }

    @Override
    public long deltaSubtract(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, -1, eventsPerStream, isNewData, context);
    }

    @Override
    public long deltaUseRuntimeTime(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext, TimeProvider timeProvider) {
        long currentTime = timeProvider.getTime();
        return this.addSubtract(currentTime, 1, eventsPerStream, true, exprEvaluatorContext);
    }

    @Override
    public TimePeriodDeltaResult deltaAddWReference(long current, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long last;
        while (reference > current) {
            reference -= this.deltaSubtract(reference, eventsPerStream, isNewData, context);
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next, eventsPerStream, isNewData, context)) <= current) {
        }
        return new TimePeriodDeltaResult(next - current, last);
    }

    @Override
    public TimePeriodProvide getNonVariableProvide(ExprEvaluatorContext context) {
        int[] added = new int[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            added[i] = ((Number)this.evaluators[i].evaluate(null, true, context)).intValue();
        }
        return new TimePeriodComputeConstGivenCalAddEval(this.adders, added, this.timeAbacus, this.indexMicroseconds, this.timeZone);
    }

    private long addSubtract(long currentTime, int factor, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        long remainder = this.timeAbacus.calendarSet(currentTime, cal);
        int usec = 0;
        for (int i = 0; i < this.adders.length; ++i) {
            int value = ((Number)this.evaluators[i].evaluate(eventsPerStream, newData, context)).intValue();
            if (i == this.indexMicroseconds) {
                usec = value;
                continue;
            }
            this.adders[i].add(cal, factor * value);
        }
        long result = this.timeAbacus.calendarGet(cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * usec);
        }
        return result - currentTime;
    }
}

