/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.processor;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstanceTable;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;

public class FireAndForgetProcessorTable
extends FireAndForgetProcessor {
    private Table table;

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public EventType getEventTypeResultSetProcessor() {
        return this.table.getMetaData().getPublicEventType();
    }

    @Override
    public String getContextName() {
        return this.table.getMetaData().getOptionalContextName();
    }

    public FireAndForgetInstance getProcessorInstance(AgentInstanceContext agentInstanceContext) {
        TableInstance instance = agentInstanceContext != null ? this.table.getTableInstance(agentInstanceContext.getAgentInstanceId()) : this.table.getTableInstanceNoContext();
        if (instance != null) {
            return new FireAndForgetInstanceTable(instance);
        }
        return null;
    }

    @Override
    public String getContextDeploymentId() {
        return this.table.getStatementContextCreateTable().getContextRuntimeDescriptor().getContextDeploymentId();
    }

    @Override
    public FireAndForgetInstance getProcessorInstanceContextById(int agentInstanceId) {
        TableInstance instance = this.table.getTableInstance(agentInstanceId);
        if (instance != null) {
            return new FireAndForgetInstanceTable(instance);
        }
        return null;
    }

    @Override
    public FireAndForgetInstance getProcessorInstanceNoContext() {
        return this.getProcessorInstance(null);
    }

    public boolean isVirtualDataWindow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EventType getEventTypePublic() {
        return this.table.getMetaData().getPublicEventType();
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public StatementContext getStatementContext() {
        return this.table.getStatementContextCreateTable();
    }
}

