/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.faf.StmtClassForgeableQueryMethodProvider;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecDelete;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementLifecycleSvcUtil;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessorForge;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessorForgeFactory;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodHelper;
import com.espertech.esper.common.internal.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperActivations;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlanner;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperPlan;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactoryForge;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class FAFQueryMethodIUDBaseForge
implements FAFQueryMethodForge {
    protected final FireAndForgetProcessorForge processor;
    protected final ExprNode whereClause;
    protected final QueryGraphForge queryGraph;
    protected final Annotation[] annotations;
    protected boolean hasTableAccess;
    protected final Map<ExprTableAccessNode, ExprTableEvalStrategyFactoryForge> tableAccessForges;
    private final Map<ExprSubselectNode, SubSelectFactoryForge> subselectForges;
    private final List<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);

    protected abstract void initExec(String var1, StatementSpecCompiled var2, StatementRawInfo var3, StatementCompileTimeServices var4) throws ExprValidationException;

    protected abstract Class typeOfMethod();

    protected abstract void makeInlineSpecificSetter(CodegenExpressionRef var1, CodegenMethod var2, SAIFFInitializeSymbol var3, CodegenClassScope var4);

    public FAFQueryMethodIUDBaseForge(StatementSpecCompiled spec, Compilable compilable, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        this.annotations = spec.getAnnotations();
        boolean bl = this.hasTableAccess = spec.getRaw().getIntoTableSpec() != null || spec.getTableAccessNodes() != null && spec.getTableAccessNodes().size() > 0;
        if (spec.getRaw().getInsertIntoDesc() != null && services.getTableCompileTimeResolver().resolve(spec.getRaw().getInsertIntoDesc().getEventTypeName()) != null) {
            this.hasTableAccess = true;
        }
        if (spec.getRaw().getFireAndForgetSpec() instanceof FireAndForgetSpecUpdate || spec.getRaw().getFireAndForgetSpec() instanceof FireAndForgetSpecDelete) {
            this.hasTableAccess |= spec.getStreamSpecs()[0] instanceof TableQueryStreamSpec;
        }
        this.hasTableAccess |= StatementLifecycleSvcUtil.isSubqueryWithTable(spec.getSubselectNodes(), services.getTableCompileTimeResolver());
        FAFQueryMethodHelper.validateFAFQuery(spec);
        StreamSpecCompiled streamSpec = spec.getStreamSpecs()[0];
        this.processor = FireAndForgetProcessorForgeFactory.validateResolveProcessor(streamSpec);
        String processorName = this.processor.getNamedWindowOrTableName();
        EventType eventType = this.processor.getEventTypeRSPInputEvents();
        String aliasName = processorName;
        if (streamSpec.getOptionalStreamName() != null) {
            aliasName = streamSpec.getOptionalStreamName();
        }
        StatementBaseInfo base = new StatementBaseInfo(compilable, spec, null, statementRawInfo, null);
        ArrayList<NamedWindowConsumerStreamSpec> subqueryNamedWindowConsumers = new ArrayList<NamedWindowConsumerStreamSpec>();
        SubSelectActivationDesc subSelectActivationDesc = SubSelectHelperActivations.createSubSelectActivation(Collections.emptyList(), subqueryNamedWindowConsumers, base, services);
        Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation = subSelectActivationDesc.getSubselects();
        this.additionalForgeables.addAll(subSelectActivationDesc.getAdditionalForgeables());
        String[] namesPerStream = new String[]{aliasName};
        EventType[] typesPerStream = new EventType[]{this.processor.getEventTypePublic()};
        String[] eventTypeNames = new String[]{typesPerStream[0].getName()};
        SubSelectHelperForgePlan subSelectForgePlan = SubSelectHelperForgePlanner.planSubSelect(base, subselectActivation, namesPerStream, typesPerStream, eventTypeNames, services);
        this.subselectForges = subSelectForgePlan.getSubselects();
        this.additionalForgeables.addAll(subSelectForgePlan.getAdditionalForgeables());
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{aliasName}, new boolean[]{true}, true, false);
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(typeService.getStreamNames(), statementRawInfo, services);
        if (spec.getRaw().getWhereClause() != null) {
            this.queryGraph = new QueryGraphForge(1, excludePlanHint, false);
            EPLValidationUtil.validateFilterWQueryGraphSafe(this.queryGraph, spec.getRaw().getWhereClause(), typeService, statementRawInfo, services);
        } else {
            this.queryGraph = null;
        }
        this.whereClause = EPStatementStartMethodHelperValidate.validateNodes(spec.getRaw(), typeService, null, statementRawInfo, services);
        this.initExec(aliasName, spec, statementRawInfo, services);
        this.tableAccessForges = ExprTableEvalHelperPlan.planTableAccess(spec.getRaw().getTableExpressions());
    }

    @Override
    public final List<StmtClassForgeable> makeForgeables(String queryMethodProviderClassName, String classPostfix, CodegenPackageScope packageScope) {
        ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>();
        for (StmtClassForgeableFactory additional : this.additionalForgeables) {
            forgeables.add(additional.make(packageScope, classPostfix));
        }
        forgeables.add(new StmtClassForgeableQueryMethodProvider(queryMethodProviderClassName, packageScope, this));
        return forgeables;
    }

    @Override
    public final void makeMethod(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenExpressionRef queryMethod = CodegenExpressionBuilder.ref("qm");
        method.getBlock().declareVar(this.typeOfMethod(), queryMethod.getRef(), CodegenExpressionBuilder.newInstance(this.typeOfMethod(), new CodegenExpression[0])).exprDotMethod(queryMethod, "setAnnotations", this.annotations == null ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.localMethod(AnnotationUtil.makeAnnotations(Annotation[].class, this.annotations, method, classScope), new CodegenExpression[0])).exprDotMethod(queryMethod, "setProcessor", this.processor.make(method, symbols, classScope)).exprDotMethod(queryMethod, "setQueryGraph", this.queryGraph == null ? CodegenExpressionBuilder.constantNull() : this.queryGraph.make(method, symbols, classScope)).exprDotMethod(queryMethod, "setInternalEventRouteDest", CodegenExpressionBuilder.exprDotMethod(symbols.getAddInitSvc(method), "getInternalEventRouteDest", new CodegenExpression[0])).exprDotMethod(queryMethod, "setTableAccesses", ExprTableEvalStrategyUtil.codegenInitMap(this.tableAccessForges, this.getClass(), method, symbols, classScope)).exprDotMethod(queryMethod, "setHasTableAccess", CodegenExpressionBuilder.constant(this.hasTableAccess)).exprDotMethod(queryMethod, "setSubselects", SubSelectFactoryForge.codegenInitMap(this.subselectForges, this.getClass(), method, symbols, classScope));
        this.makeInlineSpecificSetter(queryMethod, method, symbols, classScope);
        method.getBlock().methodReturn(queryMethod);
    }
}

