/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.util.StatementContextRuntimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethod;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecGivenContextNoJoin;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecNoContextJoin;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecNoContextNoJoin;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecSomeContextJoin;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecSomeContextNoJoin;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodUtil;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactory;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FAFQueryMethodSelect
implements FAFQueryMethod {
    private Annotation[] annotations;
    private String contextName;
    private ExprEvaluator whereClause;
    private ExprEvaluator[] consumerFilters;
    private ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider;
    private FireAndForgetProcessor[] processors;
    private JoinSetComposerPrototype joinSetComposerPrototype;
    private QueryGraph queryGraph;
    private Map<Integer, ExprTableEvalStrategyFactory> tableAccesses;
    private boolean hasTableAccess;
    private boolean isDistinct;
    private EventPropertyValueGetter distinctKeyGetter;
    private Map<Integer, SubSelectFactory> subselects;
    private FAFQueryMethodSelectExec selectExec;

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public void setProcessors(FireAndForgetProcessor[] processors) {
        this.processors = processors;
    }

    public void setResultSetProcessorFactoryProvider(ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider) {
        this.resultSetProcessorFactoryProvider = resultSetProcessorFactoryProvider;
    }

    public void setWhereClause(ExprEvaluator whereClause) {
        this.whereClause = whereClause;
    }

    public void setJoinSetComposerPrototype(JoinSetComposerPrototype joinSetComposerPrototype) {
        this.joinSetComposerPrototype = joinSetComposerPrototype;
    }

    public void setConsumerFilters(ExprEvaluator[] consumerFilters) {
        this.consumerFilters = consumerFilters;
    }

    public void setQueryGraph(QueryGraph queryGraph) {
        this.queryGraph = queryGraph;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setTableAccesses(Map<Integer, ExprTableEvalStrategyFactory> tableAccesses) {
        this.tableAccesses = tableAccesses;
    }

    public void setHasTableAccess(boolean hasTableAccess) {
        this.hasTableAccess = hasTableAccess;
    }

    public void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }

    public void setDistinctKeyGetter(EventPropertyValueGetter distinctKeyGetter) {
        this.distinctKeyGetter = distinctKeyGetter;
    }

    @Override
    public EventType getEventType() {
        return this.resultSetProcessorFactoryProvider.getResultEventType();
    }

    @Override
    public void ready(StatementContextRuntimeServices svc) {
        boolean hasContext = false;
        for (int i = 0; i < this.processors.length; ++i) {
            hasContext |= this.processors[i].getContextName() != null;
        }
        if (this.contextName == null) {
            this.selectExec = this.processors.length == 1 ? (!hasContext ? FAFQueryMethodSelectExecNoContextNoJoin.INSTANCE : FAFQueryMethodSelectExecSomeContextNoJoin.INSTANCE) : (!hasContext ? FAFQueryMethodSelectExecNoContextJoin.INSTANCE : FAFQueryMethodSelectExecSomeContextJoin.INSTANCE);
        } else {
            if (this.processors.length != 1) {
                throw new UnsupportedOperationException("Context name is not supported in a join");
            }
            if (!hasContext) {
                throw new UnsupportedOperationException("Query target is unpartitioned");
            }
            this.selectExec = FAFQueryMethodSelectExecGivenContextNoJoin.INSTANCE;
        }
        if (!this.subselects.isEmpty()) {
            FAFQueryMethodUtil.initializeSubselects(svc, this.annotations, this.subselects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EPPreparedQueryResult execute(AtomicBoolean serviceStatusProvider, FAFQueryMethodAssignerSetter assignerSetter, ContextPartitionSelector[] contextPartitionSelectors, ContextManagementService contextManagementService) {
        if (!serviceStatusProvider.get()) {
            throw FAFQueryMethodUtil.runtimeDestroyed();
        }
        if (contextPartitionSelectors != null && contextPartitionSelectors.length != this.processors.length) {
            throw new IllegalArgumentException("The number of context partition selectors does not match the number of named windows or tables in the from-clause");
        }
        try {
            EPPreparedQueryResult ePPreparedQueryResult = this.selectExec.execute(this, contextPartitionSelectors, assignerSetter, contextManagementService);
            return ePPreparedQueryResult;
        }
        finally {
            if (this.hasTableAccess) {
                this.processors[0].getStatementContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getContextName() {
        return this.contextName;
    }

    public ExprEvaluator getWhereClause() {
        return this.whereClause;
    }

    public ExprEvaluator[] getConsumerFilters() {
        return this.consumerFilters;
    }

    public ResultSetProcessorFactoryProvider getResultSetProcessorFactoryProvider() {
        return this.resultSetProcessorFactoryProvider;
    }

    public FireAndForgetProcessor[] getProcessors() {
        return this.processors;
    }

    public JoinSetComposerPrototype getJoinSetComposerPrototype() {
        return this.joinSetComposerPrototype;
    }

    public QueryGraph getQueryGraph() {
        return this.queryGraph;
    }

    public boolean isHasTableAccess() {
        return this.hasTableAccess;
    }

    public FAFQueryMethodSelectExec getSelectExec() {
        return this.selectExec;
    }

    public Map<Integer, ExprTableEvalStrategyFactory> getTableAccesses() {
        return this.tableAccesses;
    }

    public EventPropertyValueGetter getDistinctKeyGetter() {
        return this.distinctKeyGetter;
    }

    public Map<Integer, SubSelectFactory> getSubselects() {
        return this.subselects;
    }

    public void setSubselects(Map<Integer, SubSelectFactory> subselects) {
        this.subselects = subselects;
    }
}

