/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementLifecycleSvcUtil;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessorForge;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessorForgeFactory;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodHelper;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalViewableDesc;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzer;
import com.espertech.esper.common.internal.epl.join.analyze.OuterJoinAnalyzer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeForge;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeForgeFactory;
import com.espertech.esper.common.internal.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorDesc;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetSpec;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperActivations;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlanner;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperPlan;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactoryForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolverNonHA;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FAFQueryMethodSelectDesc {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final Logger log = LoggerFactory.getLogger(FAFQueryMethodSelectDesc.class);
    private final FireAndForgetProcessorForge[] processors;
    private final ResultSetProcessorDesc resultSetProcessor;
    private final QueryGraphForge queryGraph;
    private final ExprNode whereClause;
    private final ExprNode[] consumerFilters;
    private final JoinSetComposerPrototypeForge joins;
    private final Annotation[] annotations;
    private final String contextName;
    private boolean hasTableAccess;
    private final boolean isDistinct;
    private final MultiKeyClassRef distinctMultiKey;
    private Map<ExprTableAccessNode, ExprTableEvalStrategyFactoryForge> tableAccessForges;
    private final List<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
    private final Map<ExprSubselectNode, SubSelectFactoryForge> subselectForges;

    public FAFQueryMethodSelectDesc(StatementSpecCompiled statementSpec, Compilable compilable, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        this.annotations = statementSpec.getAnnotations();
        this.contextName = statementSpec.getRaw().getOptionalContextName();
        boolean queryPlanLogging = services.getConfiguration().getCommon().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            QUERY_PLAN_LOG.info("Query plans for Fire-and-forget query '" + compilable.toEPL() + "'");
        }
        this.hasTableAccess = statementSpec.getTableAccessNodes() != null && statementSpec.getTableAccessNodes().size() > 0;
        for (StreamSpecCompiled streamSpec : statementSpec.getStreamSpecs()) {
            this.hasTableAccess |= streamSpec instanceof TableQueryStreamSpec;
        }
        this.hasTableAccess |= StatementLifecycleSvcUtil.isSubqueryWithTable(statementSpec.getSubselectNodes(), services.getTableCompileTimeResolver());
        this.isDistinct = statementSpec.getSelectClauseCompiled().isDistinct();
        FAFQueryMethodHelper.validateFAFQuery(statementSpec);
        int numStreams = statementSpec.getStreamSpecs().length;
        EventType[] typesPerStream = new EventType[numStreams];
        String[] namesPerStream = new String[numStreams];
        String[] eventTypeNames = new String[numStreams];
        this.processors = new FireAndForgetProcessorForge[numStreams];
        this.consumerFilters = new ExprNode[numStreams];
        if (statementSpec.getRaw().getOptionalContextName() != null && numStreams > 1) {
            throw new ExprValidationException("Joins in runtime queries for context partitions are not supported");
        }
        for (int i = 0; i < numStreams; ++i) {
            List<ExprNode> consumerFilterExprs;
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            this.processors[i] = FireAndForgetProcessorForgeFactory.validateResolveProcessor(streamSpec);
            if (numStreams > 1 && this.processors[i].getContextName() != null) {
                throw new ExprValidationException("Joins against named windows that are under context are not supported");
            }
            String streamName = this.processors[i].getNamedWindowOrTableName();
            if (streamSpec.getOptionalStreamName() != null) {
                streamName = streamSpec.getOptionalStreamName();
            }
            namesPerStream[i] = streamName;
            typesPerStream[i] = this.processors[i].getEventTypeRSPInputEvents();
            eventTypeNames[i] = typesPerStream[i].getName();
            if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                consumerFilterExprs = namedSpec.getFilterExpressions();
            } else {
                TableQueryStreamSpec tableSpec = (TableQueryStreamSpec)streamSpec;
                consumerFilterExprs = tableSpec.getFilterExpressions();
            }
            this.consumerFilters[i] = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(consumerFilterExprs);
        }
        boolean optionalStreamsIfAny = OuterJoinAnalyzer.optionalStreamsIfAny(statementSpec.getRaw().getOuterJoinDescList());
        StreamTypeServiceImpl types = new StreamTypeServiceImpl(typesPerStream, namesPerStream, new boolean[numStreams], false, optionalStreamsIfAny);
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(types.getStreamNames(), statementRawInfo, services);
        this.queryGraph = new QueryGraphForge(numStreams, excludePlanHint, false);
        if (statementSpec.getRaw().getWhereClause() != null) {
            for (int i = 0; i < numStreams; ++i) {
                try {
                    ExprValidationContext validationContext = new ExprValidationContextBuilder(types, statementRawInfo, services).withAllowBindingConsumption(true).withIsFilterExpression(true).build();
                    ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.FILTER, statementSpec.getRaw().getWhereClause(), validationContext);
                    FilterExprAnalyzer.analyze(validated, this.queryGraph, false);
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Unexpected exception analyzing filter paths: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        StatementBaseInfo base = new StatementBaseInfo(compilable, statementSpec, null, statementRawInfo, null);
        ArrayList<NamedWindowConsumerStreamSpec> subqueryNamedWindowConsumers = new ArrayList<NamedWindowConsumerStreamSpec>();
        SubSelectActivationDesc subSelectActivationDesc = SubSelectHelperActivations.createSubSelectActivation(Collections.emptyList(), subqueryNamedWindowConsumers, base, services);
        Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation = subSelectActivationDesc.getSubselects();
        this.additionalForgeables.addAll(subSelectActivationDesc.getAdditionalForgeables());
        SubSelectHelperForgePlan subSelectForgePlan = SubSelectHelperForgePlanner.planSubSelect(base, subselectActivation, namesPerStream, typesPerStream, eventTypeNames, services);
        this.subselectForges = subSelectForgePlan.getSubselects();
        this.additionalForgeables.addAll(subSelectForgePlan.getAdditionalForgeables());
        boolean[] isIStreamOnly = new boolean[namesPerStream.length];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(typesPerStream, namesPerStream, isIStreamOnly, true, optionalStreamsIfAny);
        this.whereClause = EPStatementStartMethodHelperValidate.validateNodes(statementSpec.getRaw(), typeService, null, statementRawInfo, services);
        ResultSetSpec resultSetSpec = new ResultSetSpec(statementSpec);
        this.resultSetProcessor = ResultSetProcessorFactoryFactory.getProcessorPrototype(resultSetSpec, typeService, null, new boolean[0], true, null, true, false, statementRawInfo, services);
        this.additionalForgeables.addAll(this.resultSetProcessor.getAdditionalForgeables());
        this.tableAccessForges = ExprTableEvalHelperPlan.planTableAccess(statementSpec.getRaw().getTableExpressions());
        if (numStreams > 1) {
            StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult = new StreamJoinAnalysisResultCompileTime(numStreams);
            Arrays.fill(streamJoinAnalysisResult.getNamedWindowsPerStream(), null);
            for (int i = 0; i < numStreams; ++i) {
                String[][] uniqueIndexes = this.processors[i].getUniqueIndexes();
                streamJoinAnalysisResult.getUniqueKeys()[i] = uniqueIndexes;
            }
            boolean hasAggregations = this.resultSetProcessor.getResultSetProcessorType().isAggregated();
            JoinSetComposerPrototypeDesc desc = JoinSetComposerPrototypeForgeFactory.makeComposerPrototype(statementSpec, streamJoinAnalysisResult, types, new HistoricalViewableDesc(numStreams), true, hasAggregations, statementRawInfo, services);
            this.additionalForgeables.addAll(desc.getAdditionalForgeables());
            this.joins = desc.getForge();
        } else {
            this.joins = null;
        }
        MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKeyDistinct(this.isDistinct, this.resultSetProcessor.getResultEventType(), statementRawInfo, SerdeCompileTimeResolverNonHA.INSTANCE);
        this.additionalForgeables.addAll(multiKeyPlan.getMultiKeyForgeables());
        this.distinctMultiKey = multiKeyPlan.getClassRef();
    }

    public JoinSetComposerPrototypeForge getJoins() {
        return this.joins;
    }

    public FireAndForgetProcessorForge[] getProcessors() {
        return this.processors;
    }

    public ResultSetProcessorDesc getResultSetProcessor() {
        return this.resultSetProcessor;
    }

    public QueryGraphForge getQueryGraph() {
        return this.queryGraph;
    }

    public boolean isHasTableAccess() {
        return this.hasTableAccess;
    }

    public ExprNode getWhereClause() {
        return this.whereClause;
    }

    public ExprNode[] getConsumerFilters() {
        return this.consumerFilters;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Map<ExprTableAccessNode, ExprTableEvalStrategyFactoryForge> getTableAccessForges() {
        return this.tableAccessForges;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public List<StmtClassForgeableFactory> getAdditionalForgeables() {
        return this.additionalForgeables;
    }

    public MultiKeyClassRef getDistinctMultiKey() {
        return this.distinctMultiKey;
    }

    public Map<ExprSubselectNode, SubSelectFactoryForge> getSubselectForges() {
        return this.subselectForges;
    }
}

