/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.common;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalStreamIndexDesc;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategyForge;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategyMultiForge;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategyForge;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategyMultiForge;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeForgeFactory;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeHistoricalDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairHashKeyIndexForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class HistoricalStreamIndexListForge {
    private final int historicalStreamNum;
    private final EventType[] typesPerStream;
    private final QueryGraphForge queryGraph;
    private final TreeSet<Integer> pollingStreams;
    private Map<HistoricalStreamIndexDesc, List<Integer>> indexesUsedByStreams;
    private PollResultIndexingStrategyForge masterIndexingStrategy;

    public HistoricalStreamIndexListForge(int historicalStreamNum, EventType[] typesPerStream, QueryGraphForge queryGraph) {
        this.historicalStreamNum = historicalStreamNum;
        this.typesPerStream = typesPerStream;
        this.queryGraph = queryGraph;
        this.pollingStreams = new TreeSet();
    }

    public void addIndex(int streamViewStreamNum) {
        this.pollingStreams.add(streamViewStreamNum);
    }

    public JoinSetComposerPrototypeHistoricalDesc getStrategy(int streamViewStreamNum, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        if (this.pollingStreams.size() == 1) {
            return JoinSetComposerPrototypeForgeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum, raw, serdeResolver);
        }
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        if (this.indexesUsedByStreams == null) {
            this.indexesUsedByStreams = new LinkedHashMap<HistoricalStreamIndexDesc, List<Integer>>();
            for (int pollingStream : this.pollingStreams) {
                QueryGraphValueForge queryGraphValue = this.queryGraph.getGraphValue(pollingStream, this.historicalStreamNum);
                QueryGraphValuePairHashKeyIndexForge hashKeyProps = queryGraphValue.getHashKeyProps();
                String[] stringArray = hashKeyProps.getIndexed();
                Class[] keyTypes = this.getPropertyTypes(hashKeyProps.getKeys());
                Class[] indexTypes = this.getPropertyTypes(this.typesPerStream[this.historicalStreamNum], stringArray);
                HistoricalStreamIndexDesc desc = new HistoricalStreamIndexDesc(stringArray, indexTypes, keyTypes);
                List<Integer> usedByStreams = this.indexesUsedByStreams.get(desc);
                if (usedByStreams == null) {
                    usedByStreams = new LinkedList<Integer>();
                    this.indexesUsedByStreams.put(desc, usedByStreams);
                }
                usedByStreams.add(pollingStream);
            }
            if (this.indexesUsedByStreams.size() > 1) {
                int numIndexes = this.indexesUsedByStreams.size();
                PollResultIndexingStrategyForge[] indexingStrategies = new PollResultIndexingStrategyForge[numIndexes];
                int count = 0;
                for (Map.Entry entry : this.indexesUsedByStreams.entrySet()) {
                    int sampleStreamViewStreamNum = (Integer)((List)entry.getValue()).get(0);
                    JoinSetComposerPrototypeHistoricalDesc indexing = JoinSetComposerPrototypeForgeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[sampleStreamViewStreamNum], this.historicalStreamNum, sampleStreamViewStreamNum, raw, serdeResolver);
                    indexingStrategies[count] = indexing.getIndexingForge();
                    additionalForgeables.addAll(indexing.getAdditionalForgeables());
                    ++count;
                }
                this.masterIndexingStrategy = new PollResultIndexingStrategyMultiForge(streamViewStreamNum, indexingStrategies);
            }
        }
        if (this.indexesUsedByStreams.size() == 1) {
            return JoinSetComposerPrototypeForgeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum, raw, serdeResolver);
        }
        int indexUsed = 0;
        boolean found = false;
        for (List<Integer> desc : this.indexesUsedByStreams.values()) {
            if (desc.contains(streamViewStreamNum)) {
                found = true;
                break;
            }
            ++indexUsed;
        }
        if (!found) {
            throw new IllegalStateException("Index not found for use by stream " + streamViewStreamNum);
        }
        JoinSetComposerPrototypeHistoricalDesc indexing = JoinSetComposerPrototypeForgeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum, raw, serdeResolver);
        HistoricalIndexLookupStrategyForge innerLookupStrategy = indexing.getLookupForge();
        HistoricalIndexLookupStrategyMultiForge historicalIndexLookupStrategyMultiForge = new HistoricalIndexLookupStrategyMultiForge(indexUsed, innerLookupStrategy);
        additionalForgeables.addAll(indexing.getAdditionalForgeables());
        return new JoinSetComposerPrototypeHistoricalDesc(historicalIndexLookupStrategyMultiForge, this.masterIndexingStrategy, additionalForgeables);
    }

    private Class[] getPropertyTypes(EventType eventType, String[] properties) {
        Class[] types = new Class[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = JavaClassHelper.getBoxedType(eventType.getPropertyType(properties[i]));
        }
        return types;
    }

    private Class[] getPropertyTypes(List<QueryGraphValueEntryHashKeyedForge> hashKeys) {
        Class[] types = new Class[hashKeys.size()];
        for (int i = 0; i < hashKeys.size(); ++i) {
            types[i] = JavaClassHelper.getBoxedType(hashKeys.get(i).getKeyExpr().getForge().getEvaluationType());
        }
        return types;
    }
}

