/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.database.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.type.SQLColumnValueContext;
import com.espertech.esper.common.client.hook.type.SQLInputParameterContext;
import com.espertech.esper.common.client.hook.type.SQLOutputRowValueContext;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.historical.database.core.ConnectionCache;
import com.espertech.esper.common.internal.epl.historical.database.core.DBOutputTypeDesc;
import com.espertech.esper.common.internal.epl.historical.database.core.HistoricalEventViewableDatabaseFactory;
import com.espertech.esper.common.internal.epl.historical.execstrategy.PollExecStrategy;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.util.DatabaseTypeBinding;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollExecStrategyDBQuery
implements PollExecStrategy {
    private static final Logger JDBC_PERF_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.jdbc");
    private static final Logger log = LoggerFactory.getLogger(PollExecStrategyDBQuery.class);
    private final HistoricalEventViewableDatabaseFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private final ConnectionCache connectionCache;
    private Pair<Connection, PreparedStatement> resources;

    public PollExecStrategyDBQuery(HistoricalEventViewableDatabaseFactory factory, AgentInstanceContext agentInstanceContext, ConnectionCache connectionCache) {
        this.factory = factory;
        this.agentInstanceContext = agentInstanceContext;
        this.connectionCache = connectionCache;
    }

    @Override
    public void start() {
        this.resources = this.connectionCache.getConnection();
    }

    @Override
    public void done() {
        this.connectionCache.doneWith(this.resources);
    }

    @Override
    public void destroy() {
        this.connectionCache.destroy();
    }

    @Override
    public List<EventBean> poll(Object lookupValues, AgentInstanceContext agentInstanceContext) {
        List<EventBean> result;
        try {
            result = this.execute(this.resources.getSecond(), lookupValues);
        }
        catch (EPException ex) {
            this.connectionCache.doneWith(this.resources);
            throw ex;
        }
        return result;
    }

    private synchronized List<EventBean> execute(PreparedStatement preparedStatement, Object lookupValuePerStream) {
        ResultSet resultSet;
        boolean hasJDBCLogging = this.factory.enableJDBCLogging && JDBC_PERF_LOG.isInfoEnabled();
        SQLInputParameterContext inputParameterContext = null;
        if (this.factory.columnTypeConversionHook != null) {
            inputParameterContext = new SQLInputParameterContext();
        }
        int count = 1;
        Object[] parameters = null;
        if (hasJDBCLogging) {
            parameters = new Object[this.factory.inputParameters.length];
        }
        Object[] mk = this.factory.inputParameters.length == 1 ? null : (Object[])lookupValuePerStream;
        for (int i = 0; i < this.factory.inputParameters.length; ++i) {
            try {
                Object parameter = mk == null ? lookupValuePerStream : mk[i];
                if (this.factory.columnTypeConversionHook != null) {
                    inputParameterContext.setParameterNumber(i + 1);
                    inputParameterContext.setParameterValue(parameter);
                    parameter = this.factory.columnTypeConversionHook.getParameterValue(inputParameterContext);
                }
                this.setObject(preparedStatement, count, parameter);
                if (parameters != null) {
                    parameters[i] = parameter;
                }
            }
            catch (SQLException ex) {
                throw new EPException("Error setting parameter " + count, ex);
            }
            ++count;
        }
        if (hasJDBCLogging) {
            long startTimeNS = System.nanoTime();
            long startTimeMS = System.currentTimeMillis();
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException ex) {
                throw new EPException("Error executing statement '" + this.factory.preparedStatementText + '\'', ex);
            }
            long endTimeNS = System.nanoTime();
            long endTimeMS = System.currentTimeMillis();
            JDBC_PERF_LOG.info("Statement '" + this.factory.preparedStatementText + "' delta nanosec " + (endTimeNS - startTimeNS) + " delta msec " + (endTimeMS - startTimeMS) + " parameters " + Arrays.toString(parameters));
        } else {
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException ex) {
                throw new EPException("Error executing statement '" + this.factory.preparedStatementText + '\'', ex);
            }
        }
        LinkedList<EventBean> rows = new LinkedList<EventBean>();
        try {
            SQLColumnValueContext valueContext = null;
            if (this.factory.columnTypeConversionHook != null) {
                valueContext = new SQLColumnValueContext();
            }
            SQLOutputRowValueContext rowContext = null;
            if (this.factory.outputRowConversionHook != null) {
                rowContext = new SQLOutputRowValueContext();
            }
            int rowNum = 0;
            while (resultSet.next()) {
                int colNum = 1;
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Map.Entry<String, DBOutputTypeDesc> entry : this.factory.outputTypes.entrySet()) {
                    String columnName = entry.getKey();
                    DatabaseTypeBinding binding = entry.getValue().getOptionalBinding();
                    Object value = binding != null ? binding.getValue(resultSet, columnName) : resultSet.getObject(columnName);
                    if (this.factory.columnTypeConversionHook != null) {
                        valueContext.setColumnName(columnName);
                        valueContext.setColumnNumber(colNum);
                        valueContext.setColumnValue(value);
                        valueContext.setResultSet(resultSet);
                        value = this.factory.columnTypeConversionHook.getColumnValue(valueContext);
                    }
                    row.put(columnName, value);
                    ++colNum;
                }
                EventBean eventBeanRow = null;
                if (this.factory.outputRowConversionHook == null) {
                    eventBeanRow = this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedMap(row, this.factory.getEventType());
                } else {
                    rowContext.setValues(row);
                    rowContext.setRowNum(rowNum);
                    rowContext.setResultSet(resultSet);
                    Object rowData = this.factory.outputRowConversionHook.getOutputRow(rowContext);
                    if (rowData != null) {
                        eventBeanRow = this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedBean(rowData, (BeanEventType)this.factory.getEventType());
                    }
                }
                if (eventBeanRow == null) continue;
                rows.add(eventBeanRow);
                ++rowNum;
            }
        }
        catch (SQLException ex) {
            throw new EPException("Error reading results for statement '" + this.factory.preparedStatementText + '\'', ex);
        }
        if (this.factory.enableJDBCLogging && JDBC_PERF_LOG.isInfoEnabled()) {
            JDBC_PERF_LOG.info("Statement '" + this.factory.preparedStatementText + "' " + rows.size() + " rows");
        }
        try {
            resultSet.close();
        }
        catch (SQLException ex) {
            throw new EPException("Error closing statement '" + this.factory.preparedStatementText + '\'', ex);
        }
        return rows;
    }

    private void setObject(PreparedStatement preparedStatement, int column, Object value) throws SQLException {
        if (value instanceof Date) {
            value = new Timestamp(((Date)value).getTime());
        } else if (value instanceof Calendar) {
            value = new Timestamp(((Calendar)value).getTimeInMillis());
        }
        preparedStatement.setObject(column, value);
    }
}

