/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.advanced.index.quadtree;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.AdvancedIndexConfigStatementMXCIFQuadtree;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.EventTableQuadTree;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.AdvancedIndexEvaluationHelper;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeRowIndexAdd;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeRowIndexQuery;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeRowIndexRemove;
import java.util.Collection;
import java.util.Iterator;

public class EventTableQuadTreeMXCIFImpl
implements EventTableQuadTree {
    private final EventTableOrganization organization;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final AdvancedIndexConfigStatementMXCIFQuadtree config;
    private final MXCIFQuadTree<Object> quadTree;

    public EventTableQuadTreeMXCIFImpl(EventTableOrganization organization, AdvancedIndexConfigStatementMXCIFQuadtree config, MXCIFQuadTree<Object> quadTree) {
        this.organization = organization;
        this.config = config;
        this.quadTree = quadTree;
    }

    @Override
    public Collection<EventBean> queryRange(double x, double y, double width, double height) {
        return MXCIFQuadTreeRowIndexQuery.queryRange(this.quadTree, x, y, width, height);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        exprEvaluatorContext.getInstrumentationProvider().qIndexAddRemove(this, newData, oldData);
        this.remove(oldData, exprEvaluatorContext);
        this.add(newData, exprEvaluatorContext);
        exprEvaluatorContext.getInstrumentationProvider().aIndexAddRemove();
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean added : events) {
            this.add(added, exprEvaluatorContext);
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean removed : events) {
            this.remove(removed, exprEvaluatorContext);
        }
    }

    @Override
    public void add(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        double height;
        double width;
        double y;
        this.eventsPerStream[0] = event;
        double x = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getxEval(), this.organization.getIndexName(), "x", this.eventsPerStream, true, exprEvaluatorContext);
        boolean added = MXCIFQuadTreeRowIndexAdd.add(x, y = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getyEval(), this.organization.getIndexName(), "y", this.eventsPerStream, true, exprEvaluatorContext), width = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getWidthEval(), this.organization.getIndexName(), "width", this.eventsPerStream, true, exprEvaluatorContext), height = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getHeightEval(), this.organization.getIndexName(), "height", this.eventsPerStream, true, exprEvaluatorContext), event, this.quadTree, this.organization.isUnique(), this.organization.getIndexName());
        if (!added) {
            throw AdvancedIndexEvaluationHelper.invalidColumnValue(this.organization.getIndexName(), "(x,y,width,height)", "(" + x + "," + y + "," + width + "," + height + ")", "a value intersecting index bounding box (range-end-inclusive) " + this.quadTree.getRoot().getBb());
        }
    }

    @Override
    public void remove(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[0] = event;
        double x = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getxEval(), this.organization.getIndexName(), "x", this.eventsPerStream, false, exprEvaluatorContext);
        double y = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getyEval(), this.organization.getIndexName(), "y", this.eventsPerStream, false, exprEvaluatorContext);
        double width = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getWidthEval(), this.organization.getIndexName(), "width", this.eventsPerStream, false, exprEvaluatorContext);
        double height = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getHeightEval(), this.organization.getIndexName(), "height", this.eventsPerStream, false, exprEvaluatorContext);
        MXCIFQuadTreeRowIndexRemove.remove(x, y, width, height, event, this.quadTree);
    }

    @Override
    public Iterator<EventBean> iterator() {
        BoundingBox bb = this.quadTree.getRoot().getBb();
        Collection<EventBean> events = this.queryRange(bb.getMinX(), bb.getMinY(), bb.getMaxX() - bb.getMinX(), bb.getMaxY() - bb.getMinY());
        return events.iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
        this.quadTree.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().toString();
    }

    @Override
    public Class getProviderClass() {
        return this.getClass();
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    @Override
    public int getNumKeys() {
        return -1;
    }

    @Override
    public Object getIndex() {
        return this.quadTree;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.organization;
    }
}

