/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.composite;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.composite.PropertyCompositeEventTable;
import com.espertech.esper.common.internal.epl.index.composite.PropertyCompositeEventTableFactoryFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyCompositeEventTableFactoryFactoryForge
implements EventTableFactoryFactoryForge {
    private final int indexedStreamNum;
    private final Integer subqueryNum;
    private final boolean isFireAndForget;
    private final String[] optKeyProps;
    private final Class[] optKeyTypes;
    private final MultiKeyClassRef hashMultikeyClasses;
    private final String[] rangeProps;
    private final Class[] rangeTypes;
    private final DataInputOutputSerdeForge[] rangeSerdes;
    private final EventType eventType;

    public PropertyCompositeEventTableFactoryFactoryForge(int indexedStreamNum, Integer subqueryNum, boolean isFireAndForget, String[] optKeyProps, Class[] optKeyTypes, MultiKeyClassRef hashMultikeyClasses, String[] rangeProps, Class[] rangeTypes, DataInputOutputSerdeForge[] rangeSerdes, EventType eventType) {
        this.indexedStreamNum = indexedStreamNum;
        this.subqueryNum = subqueryNum;
        this.isFireAndForget = isFireAndForget;
        this.optKeyProps = optKeyProps;
        this.optKeyTypes = optKeyTypes;
        this.hashMultikeyClasses = hashMultikeyClasses;
        this.rangeProps = rangeProps;
        this.rangeTypes = rangeTypes;
        this.rangeSerdes = rangeSerdes;
        this.eventType = eventType;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getName() + " streamNum=" + this.indexedStreamNum + " keys=" + this.optKeyProps == null ? "none" : Arrays.toString(this.optKeyProps) + " ranges=" + Arrays.toString(this.rangeProps);
    }

    @Override
    public Class getEventTableClass() {
        return PropertyCompositeEventTable.class;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(PropertyCompositeEventTableFactoryFactory.class, this.getClass(), (CodegenScope)classScope);
        CodegenExpression hashGetter = CodegenExpressionBuilder.constantNull();
        if (this.optKeyProps != null && this.optKeyProps.length > 0) {
            Class[] propertyTypes = EventTypeUtility.getPropertyTypes(this.eventType, this.optKeyProps);
            EventPropertyGetterSPI[] getters = EventTypeUtility.getGetters(this.eventType, this.optKeyProps);
            hashGetter = MultiKeyCodegen.codegenGetterMayMultiKey(this.eventType, getters, propertyTypes, this.optKeyTypes, this.hashMultikeyClasses, method, classScope);
        }
        method.getBlock().declareVar(EventPropertyValueGetter[].class, "rangeGetters", CodegenExpressionBuilder.newArrayByLength(EventPropertyValueGetter.class, CodegenExpressionBuilder.constant(this.rangeProps.length)));
        for (int i = 0; i < this.rangeProps.length; ++i) {
            Class propertyType = this.eventType.getPropertyType(this.rangeProps[i]);
            EventPropertyGetterSPI getterSPI = ((EventTypeSPI)this.eventType).getGetterSPI(this.rangeProps[i]);
            CodegenExpression getter = EventTypeUtility.codegenGetterWCoerce(getterSPI, propertyType, this.rangeTypes[i], method, this.getClass(), classScope);
            method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("rangeGetters"), CodegenExpressionBuilder.constant(i), getter);
        }
        ArrayList<CodegenExpression> params = new ArrayList<CodegenExpression>();
        params.add(CodegenExpressionBuilder.constant(this.indexedStreamNum));
        params.add(CodegenExpressionBuilder.constant(this.subqueryNum));
        params.add(CodegenExpressionBuilder.constant(this.isFireAndForget));
        params.add(CodegenExpressionBuilder.constant(this.optKeyProps));
        params.add(CodegenExpressionBuilder.constant(this.optKeyTypes));
        params.add(hashGetter);
        params.add(this.hashMultikeyClasses.getExprMKSerde(method, classScope));
        params.add(CodegenExpressionBuilder.constant(this.rangeProps));
        params.add(CodegenExpressionBuilder.constant(this.rangeTypes));
        params.add(CodegenExpressionBuilder.ref("rangeGetters"));
        params.add(DataInputOutputSerdeForge.codegenArray(this.rangeSerdes, method, classScope, null));
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(PropertyCompositeEventTableFactoryFactory.class, params.toArray(new CodegenExpression[0])));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

